/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.attachment.AcraContentProvider;
import org.acra.attachment.AttachmentUriProvider;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.MailSenderConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.sender.EmailIntentSender;
import org.acra.sender.EmailIntentSenderKt;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.IOUtils;
import org.acra.util.InstanceCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0012J\b\u0010\u0015\u001a\u00020\bH\u0014J\"\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u000eH\u0014J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0014J*\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\nH\u0014J \u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0012J0\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0012J\b\u0010)\u001a\u00020*H\u0017J.\u0010+\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0012J\u0018\u0010,\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0016J.\u0010/\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0013J\u001e\u00100\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b01H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/acra/sender/EmailIntentSender;", "Lorg/acra/sender/ReportSender;", "config", "Lorg/acra/config/CoreConfiguration;", "(Lorg/acra/config/CoreConfiguration;)V", "mailConfig", "Lorg/acra/config/MailSenderConfiguration;", "buildAttachmentIntent", "Landroid/content/Intent;", "subject", "", "body", "attachments", "", "Landroid/net/Uri;", "buildFallbackIntent", "buildInitialIntents", "pm", "Landroid/content/pm/PackageManager;", "resolveIntent", "emailIntent", "buildResolveIntent", "buildSingleAttachmentIntent", "attachment", "buildSubject", "context", "Landroid/content/Context;", "createAttachmentFromString", "name", "content", "getBodyAndAttachments", "Lkotlin/Pair;", "reportText", "getPackageName", "resolveActivity", "Landroid/content/ComponentName;", "initialIntents", "grantPermission", "", "intent", "packageName", "requiresForeground", "", "resolveAndSend", "send", "errorContent", "Lorg/acra/data/CrashReportData;", "sendWithSelector", "showChooser", "", "Companion", "acra-mail_release"})
@SourceDebugExtension(value={"SMAP\nEmailIntentSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmailIntentSender.kt\norg/acra/sender/EmailIntentSender\n+ 2 ConfigUtils.kt\norg/acra/config/ConfigUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 extensions.kt\norg/acra/log/ExtensionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,320:1\n29#2:321\n1#3:322\n15#4,2:323\n37#5,2:325\n*S KotlinDebug\n*F\n+ 1 EmailIntentSender.kt\norg/acra/sender/EmailIntentSender\n*L\n51#1:321\n108#1:323,2\n237#1:325,2\n*E\n"})
public class EmailIntentSender
implements ReportSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final MailSenderConfiguration mailConfig;
    @NotNull
    public static final String DEFAULT_REPORT_FILENAME = "ACRA-report.stacktrace";

    public EmailIntentSender(@NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CoreConfiguration $this$getPluginConfiguration$iv = this.config = config;
        boolean $i$f$getPluginConfiguration = false;
        this.mailConfig = (MailSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)$this$getPluginConfiguration$iv, MailSenderConfiguration.class);
    }

    public void send(@NotNull Context context, @NotNull CrashReportData errorContent) throws ReportSenderException {
        Pair<String, List<Uri>> pair;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        String subject = this.buildSubject(context);
        try {
            pair = this.config.getReportFormat().toFormattedString(errorContent, this.config.getReportContent(), "\n", "\n  ", false);
        }
        catch (Exception e) {
            throw new ReportSenderException("Failed to convert Report to text", (Throwable)e);
        }
        Pair<String, List<Uri>> reportText = pair;
        pair = this.getBodyAndAttachments(context, (String)reportText);
        String body = (String)pair.component1();
        List attachments = (List)pair.component2();
        int n = Build.VERSION.SDK_INT;
        boolean bl = 23 <= n ? n < 33 : false;
        if (bl) {
            this.sendWithSelector(subject, body, attachments, context);
        } else {
            this.resolveAndSend(subject, body, attachments, context);
        }
    }

    private void resolveAndSend(String subject, String body, List<? extends Uri> attachments, Context context) {
        PackageManager pm = context.getPackageManager();
        Intent resolveIntent = this.buildResolveIntent();
        ComponentName resolveActivity = resolveIntent.resolveActivity(pm);
        if (resolveActivity != null) {
            if (attachments.isEmpty()) {
                context.startActivity(this.buildFallbackIntent(subject, body));
            } else {
                Intent intent;
                Intent attachmentIntent = this.buildAttachmentIntent(subject, body, attachments);
                Intent $this$resolveAndSend_u24lambda_u240 = intent = new Intent(attachmentIntent);
                boolean bl = false;
                $this$resolveAndSend_u24lambda_u240.setType("*/*");
                Intent altAttachmentIntent = intent;
                Intrinsics.checkNotNullExpressionValue((Object)pm, (String)"pm");
                List<Intent> initialIntents = this.buildInitialIntents(pm, resolveIntent, attachmentIntent);
                String packageName = this.getPackageName(resolveActivity, initialIntents);
                attachmentIntent.setPackage(packageName);
                altAttachmentIntent.setPackage(packageName);
                if (packageName == null) {
                    for (Intent intent2 : initialIntents) {
                        this.grantPermission(context, intent2, intent2.getPackage(), attachments);
                    }
                    this.showChooser(context, CollectionsKt.toMutableList((Collection)initialIntents));
                } else if (attachmentIntent.resolveActivity(pm) != null) {
                    this.grantPermission(context, attachmentIntent, packageName, attachments);
                    context.startActivity(attachmentIntent);
                } else if (altAttachmentIntent.resolveActivity(pm) != null) {
                    this.grantPermission(context, altAttachmentIntent, packageName, attachments);
                    context.startActivity(altAttachmentIntent);
                } else {
                    boolean $i$f$warn = false;
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl2 = false;
                    String string2 = "No email client supporting attachments found. Attachments will be ignored";
                    aCRALog.w(string, string2);
                    context.startActivity(this.buildFallbackIntent(subject, body));
                }
            }
        } else {
            throw new ReportSenderException("No email client found");
        }
    }

    @RequiresApi(value=15)
    private void sendWithSelector(String subject, String body, List<? extends Uri> attachments, Context context) {
        Intent intent = attachments.size() == 1 ? this.buildSingleAttachmentIntent(subject, body, (Uri)CollectionsKt.first(attachments)) : this.buildAttachmentIntent(subject, body, attachments);
        intent.setSelector(this.buildResolveIntent());
        this.grantPermission(context, intent, null, attachments);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            try {
                this.resolveAndSend(subject, body, attachments, context);
            }
            catch (ActivityNotFoundException e2) {
                ReportSenderException reportSenderException;
                ReportSenderException $this$sendWithSelector_u24lambda_u242 = reportSenderException = new ReportSenderException("No email client found", (Throwable)e2);
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$sendWithSelector_u24lambda_u242), (Throwable)e);
                throw (Throwable)reportSenderException;
            }
        }
    }

    @ChecksSdkIntAtLeast(api=29)
    public boolean requiresForeground() {
        return Build.VERSION.SDK_INT >= 29;
    }

    private String getPackageName(ComponentName resolveActivity, List<? extends Intent> initialIntents) {
        String packageName = resolveActivity.getPackageName();
        if (Intrinsics.areEqual((Object)packageName, (Object)"android")) {
            if (initialIntents.size() > 1) {
                packageName = null;
            } else if (initialIntents.size() == 1) {
                packageName = initialIntents.get(0).getPackage();
            }
        }
        return packageName;
    }

    @NotNull
    protected Intent buildAttachmentIntent(@NotNull String subject, @Nullable String body, @NotNull List<? extends Uri> attachments) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        String[] stringArray = new String[]{this.mailConfig.getMailTo()};
        intent.putExtra("android.intent.extra.EMAIL", stringArray);
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", (ArrayList)CollectionsKt.toCollection((Iterable)attachments, (Collection)new ArrayList()));
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    @NotNull
    protected Intent buildSingleAttachmentIntent(@NotNull String subject, @Nullable String body, @NotNull Uri attachment) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intent intent = new Intent("android.intent.action.SEND");
        String[] stringArray = new String[]{this.mailConfig.getMailTo()};
        intent.putExtra("android.intent.extra.EMAIL", stringArray);
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)attachment);
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    @NotNull
    protected Intent buildResolveIntent() {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)"mailto:"));
        intent.addFlags(0x10000000);
        return intent;
    }

    @NotNull
    protected Intent buildFallbackIntent(@NotNull String subject, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)("mailto:" + this.mailConfig.getMailTo() + "?subject=" + Uri.encode((String)subject) + "&body=" + Uri.encode((String)body))));
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    private List<Intent> buildInitialIntents(PackageManager pm, Intent resolveIntent, Intent emailIntent) {
        List resolveInfoList = EmailIntentSenderKt.access$queryDefaultActivities(pm, resolveIntent);
        List initialIntents = new ArrayList();
        for (ResolveInfo info : resolveInfoList) {
            Intent packageSpecificIntent = new Intent(emailIntent);
            packageSpecificIntent.setPackage(info.activityInfo.packageName);
            if (packageSpecificIntent.resolveActivity(pm) == null) continue;
            initialIntents.add(packageSpecificIntent);
        }
        return initialIntents;
    }

    private void showChooser(Context context, List<Intent> initialIntents) {
        Intent chooser = new Intent("android.intent.action.CHOOSER");
        chooser.putExtra("android.intent.extra.INTENT", (Parcelable)initialIntents.remove(0));
        Collection $this$toTypedArray$iv = initialIntents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        chooser.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])thisCollection$iv.toArray(new Intent[0]));
        chooser.addFlags(0x10000000);
        context.startActivity(chooser);
    }

    private void grantPermission(Context context, Intent intent, String packageName, List<? extends Uri> attachments) {
        if (packageName == null) {
            PackageManager packageManager = context.getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
            for (ResolveInfo resolveInfo : EmailIntentSenderKt.access$queryDefaultActivities(packageManager, intent)) {
                this.grantPermission(context, intent, resolveInfo.activityInfo.packageName, attachments);
            }
        } else {
            for (Uri uri : attachments) {
                context.grantUriPermission(packageName, uri, 1);
            }
        }
    }

    @NotNull
    protected String buildSubject(@NotNull Context context) {
        String subject;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = subject = this.mailConfig.getSubject();
        return (string != null ? ((CharSequence)string).length() > 0 : false) ? subject : context.getPackageName() + " Crash Report";
    }

    @NotNull
    protected Pair<String, List<Uri>> getBodyAndAttachments(@NotNull Context context, @NotNull String reportText) {
        Uri report;
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
        String bodyPrefix = this.mailConfig.getBody();
        if (this.mailConfig.getReportAsFile()) {
            object = bodyPrefix;
            if (object == null) {
                object = "";
            }
        } else {
            String string = bodyPrefix;
            object = (string != null ? ((CharSequence)string).length() > 0 : false) ? bodyPrefix + "\n" + reportText : reportText;
        }
        String body = object;
        List attachments = new ArrayList();
        attachments.addAll(((AttachmentUriProvider)InstanceCreator.create((Class)this.config.getAttachmentUriProvider(), (Function0)getBodyAndAttachments.1.INSTANCE)).getAttachments(context, this.config));
        if (this.mailConfig.getReportAsFile() && (report = this.createAttachmentFromString(context, this.mailConfig.getReportFileName(), reportText)) != null) {
            attachments.add(report);
        }
        return TuplesKt.to((Object)body, (Object)attachments);
    }

    @Nullable
    protected Uri createAttachmentFromString(@NotNull Context context, @NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File cache = new File(context.getCacheDir(), name);
        try {
            IOUtils.writeStringToFile((File)cache, (String)content);
            return AcraContentProvider.Companion.getUriForFile(context, cache);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/acra/sender/EmailIntentSender$Companion;", "", "()V", "DEFAULT_REPORT_FILENAME", "", "acra-mail_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

