/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import org.acra.annotation.AcraMailSender;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.MailSenderConfiguration;
import org.acra.config.MailSenderConfigurationBuilder;

final class MailSenderConfigurationBuilderImpl
implements MailSenderConfigurationBuilder {
    @NonNull
    private final Context context;
    private boolean enabled;
    @NonNull
    private String mailTo;
    private boolean reportAsFile;
    @NonNull
    private String reportFileName;
    @Nullable
    private String subject;
    @Nullable
    private String body;

    MailSenderConfigurationBuilderImpl(@NonNull Context arg0) {
        AcraMailSender annotation = arg0.getClass().getAnnotation(AcraMailSender.class);
        this.context = arg0;
        boolean bl = this.enabled = annotation != null;
        if (this.enabled) {
            this.mailTo = annotation.mailTo();
            this.reportAsFile = annotation.reportAsFile();
            this.reportFileName = annotation.reportFileName();
            if (annotation.resSubject() != 0) {
                this.subject = this.context.getString(annotation.resSubject());
            }
            if (annotation.resBody() != 0) {
                this.body = this.context.getString(annotation.resBody());
            }
        } else {
            this.reportAsFile = true;
            this.reportFileName = "ACRA-report.stacktrace";
        }
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    boolean enabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setMailTo(@NonNull String mailTo) {
        this.mailTo = mailTo;
        return this;
    }

    @NonNull
    String mailTo() {
        return this.mailTo;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setReportAsFile(boolean reportAsFile) {
        this.reportAsFile = reportAsFile;
        return this;
    }

    boolean reportAsFile() {
        return this.reportAsFile;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setReportFileName(@NonNull String reportFileName) {
        this.reportFileName = reportFileName;
        return this;
    }

    @NonNull
    String reportFileName() {
        return this.reportFileName;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setSubject(@Nullable String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setResSubject(@StringRes int resSubject) {
        this.subject = this.context.getString(resSubject);
        return this;
    }

    @Nullable
    String subject() {
        return this.subject;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setBody(@Nullable String body) {
        this.body = body;
        return this;
    }

    @Override
    @NonNull
    public MailSenderConfigurationBuilderImpl setResBody(@StringRes int resBody) {
        this.body = this.context.getString(resBody);
        return this;
    }

    @Nullable
    String body() {
        return this.body;
    }

    @NonNull
    public MailSenderConfiguration build() throws ACRAConfigurationException {
        if (this.enabled && this.mailTo == null) {
            throw new ACRAConfigurationException("mailTo has to be set");
        }
        return new MailSenderConfiguration(this);
    }
}

