/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.acra.ACRA;
import org.acra.attachment.AcraContentProvider;
import org.acra.attachment.AttachmentUriProvider;
import org.acra.attachment.DefaultAttachmentProvider;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.MailSenderConfiguration;
import org.acra.data.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.IOUtils;
import org.acra.util.InstanceCreator;

public class EmailIntentSender
implements ReportSender {
    public static final String DEFAULT_REPORT_FILENAME = "ACRA-report.stacktrace";
    private final CoreConfiguration config;
    private final MailSenderConfiguration mailConfig;

    public EmailIntentSender(@NonNull CoreConfiguration config) {
        this.config = config;
        this.mailConfig = (MailSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, MailSenderConfiguration.class);
    }

    public void send(@NonNull Context context, @NonNull CrashReportData errorContent) throws ReportSenderException {
        String reportText;
        PackageManager pm = context.getPackageManager();
        String subject = this.buildSubject(context);
        try {
            reportText = this.config.reportFormat().toFormattedString(errorContent, this.config.reportContent(), "\n", "\n\t", false);
        }
        catch (Exception e) {
            throw new ReportSenderException("Failed to convert Report to text", (Throwable)e);
        }
        String bodyPrefix = this.mailConfig.body();
        String body = bodyPrefix != null ? bodyPrefix + "\n" + reportText : reportText;
        ArrayList<Uri> attachments = new ArrayList<Uri>();
        boolean contentAttached = this.fillAttachmentList(context, reportText, attachments);
        Intent resolveIntent = this.buildResolveIntent(subject, body);
        ComponentName resolveActivity = resolveIntent.resolveActivity(pm);
        if (resolveActivity != null) {
            if (attachments.size() == 0) {
                context.startActivity(resolveIntent);
            } else {
                Intent attachmentIntent = this.buildAttachmentIntent(subject, contentAttached ? bodyPrefix : body, attachments);
                List<Intent> initialIntents = this.buildInitialIntents(pm, resolveIntent, attachmentIntent);
                String packageName = this.getPackageName(resolveActivity, initialIntents);
                attachmentIntent.setPackage(packageName);
                if (packageName == null) {
                    for (Intent intent : initialIntents) {
                        this.grantPermission(context, intent, intent.getPackage(), attachments);
                    }
                    this.showChooser(context, initialIntents);
                } else if (attachmentIntent.resolveActivity(pm) != null) {
                    this.grantPermission(context, attachmentIntent, packageName, attachments);
                    context.startActivity(attachmentIntent);
                } else {
                    ACRA.log.w(ACRA.LOG_TAG, "No email client supporting attachments found. Attachments will be ignored");
                    context.startActivity(resolveIntent);
                }
            }
        } else {
            throw new ReportSenderException("No email client found");
        }
    }

    public boolean requiresForeground() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @Nullable
    private String getPackageName(@NonNull ComponentName resolveActivity, @NonNull List<Intent> initialIntents) {
        String packageName = resolveActivity.getPackageName();
        if (packageName.equals("android")) {
            if (initialIntents.size() > 1) {
                packageName = null;
            } else if (initialIntents.size() == 1) {
                packageName = initialIntents.get(0).getPackage();
            }
        }
        return packageName;
    }

    @NonNull
    protected Intent buildAttachmentIntent(@NonNull String subject, @Nullable String body, @NonNull ArrayList<Uri> attachments) {
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.putExtra("android.intent.extra.EMAIL", new String[]{this.mailConfig.mailTo()});
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.setType("message/rfc822");
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", attachments);
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    @NonNull
    protected Intent buildResolveIntent(@NonNull String subject, @NonNull String body) {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.fromParts((String)"mailto", (String)this.mailConfig.mailTo(), null));
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    @NonNull
    private List<Intent> buildInitialIntents(@NonNull PackageManager pm, @NonNull Intent resolveIntent, @NonNull Intent emailIntent) {
        List resolveInfoList = pm.queryIntentActivities(resolveIntent, 65536);
        ArrayList<Intent> initialIntents = new ArrayList<Intent>();
        for (ResolveInfo info : resolveInfoList) {
            Intent packageSpecificIntent = new Intent(emailIntent);
            packageSpecificIntent.setPackage(info.activityInfo.packageName);
            if (packageSpecificIntent.resolveActivity(pm) == null) continue;
            initialIntents.add(packageSpecificIntent);
        }
        return initialIntents;
    }

    private void showChooser(@NonNull Context context, @NonNull List<Intent> initialIntents) {
        Intent chooser = new Intent("android.intent.action.CHOOSER");
        chooser.putExtra("android.intent.extra.INTENT", (Parcelable)initialIntents.remove(0));
        chooser.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])initialIntents.toArray(new Intent[initialIntents.size()]));
        chooser.addFlags(0x10000000);
        context.startActivity(chooser);
    }

    private void grantPermission(@NonNull Context context, @NonNull Intent intent, String packageName, @NonNull List<Uri> attachments) {
        if (Build.VERSION.SDK_INT >= 21) {
            intent.addFlags(1);
        } else {
            for (Uri uri : attachments) {
                context.grantUriPermission(packageName, uri, 1);
            }
        }
    }

    @NonNull
    protected String buildSubject(@NonNull Context context) {
        String subject = this.mailConfig.subject();
        if (subject != null) {
            return subject;
        }
        return context.getPackageName() + " Crash Report";
    }

    protected boolean fillAttachmentList(@NonNull Context context, @NonNull String reportText, @NonNull List<Uri> attachments) {
        Uri report;
        InstanceCreator instanceCreator = new InstanceCreator();
        attachments.addAll(((AttachmentUriProvider)instanceCreator.create(this.config.attachmentUriProvider(), DefaultAttachmentProvider::new)).getAttachments(context, this.config));
        if (this.mailConfig.reportAsFile() && (report = this.createAttachmentFromString(context, this.mailConfig.reportFileName(), reportText)) != null) {
            attachments.add(report);
            return true;
        }
        return false;
    }

    @Nullable
    protected Uri createAttachmentFromString(@NonNull Context context, @NonNull String name, @NonNull String content) {
        File cache = new File(context.getCacheDir(), name);
        try {
            IOUtils.writeStringToFile((File)cache, (String)content);
            return AcraContentProvider.getUriForFile((Context)context, (File)cache);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

