/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.RequiresApi;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.attachment.AcraContentProvider;
import org.acra.attachment.AttachmentUriProvider;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.MailSenderConfiguration;
import org.acra.data.CrashReportData;
import org.acra.log.ACRALog;
import org.acra.sender.EmailIntentSender;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.IOUtils;
import org.acra.util.InstanceCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0012J\b\u0010\u0016\u001a\u00020\bH\u0014J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\"\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0014J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0 H\u0014J \u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0012J0\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0012J\b\u0010)\u001a\u00020\u001eH\u0016J\u0018\u0010*\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,H\u0016J>\u0010-\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\nH\u0012J>\u00100\u001a\u00020&2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\nH\u0013J\u001e\u00101\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0 H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/acra/sender/EmailIntentSender;", "Lorg/acra/sender/ReportSender;", "config", "Lorg/acra/config/CoreConfiguration;", "(Lorg/acra/config/CoreConfiguration;)V", "mailConfig", "Lorg/acra/config/MailSenderConfiguration;", "buildAttachmentIntent", "Landroid/content/Intent;", "subject", "", "body", "attachments", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "buildFallbackIntent", "buildInitialIntents", "", "pm", "Landroid/content/pm/PackageManager;", "resolveIntent", "emailIntent", "buildResolveIntent", "buildSubject", "context", "Landroid/content/Context;", "createAttachmentFromString", "name", "content", "fillAttachmentList", "", "reportText", "", "getPackageName", "resolveActivity", "Landroid/content/ComponentName;", "initialIntents", "grantPermission", "", "intent", "packageName", "requiresForeground", "send", "errorContent", "Lorg/acra/data/CrashReportData;", "sendLegacy", "contentAttached", "bodyPrefix", "sendWithSelector", "showChooser", "Companion", "acra-mail_release"})
public class EmailIntentSender
implements ReportSender {
    private final MailSenderConfiguration mailConfig;
    private final CoreConfiguration config;
    @NotNull
    public static final String DEFAULT_REPORT_FILENAME = "ACRA-report.stacktrace";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void send(@NotNull Context context, @NotNull CrashReportData errorContent) throws ReportSenderException {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        String subject = this.buildSubject(context);
        try {
            string = this.config.getReportFormat().toFormattedString(errorContent, this.config.getReportContent(), "\n", "\n\t", false);
        }
        catch (Exception e) {
            throw (Throwable)new ReportSenderException("Failed to convert Report to text", (Throwable)e);
        }
        String reportText = string;
        String bodyPrefix = this.mailConfig.getBody();
        CharSequence charSequence = bodyPrefix;
        boolean bl = false;
        String body = charSequence.length() > 0 ? bodyPrefix + '\n' + reportText : reportText;
        ArrayList<Uri> attachments = new ArrayList<Uri>();
        boolean contentAttached = this.fillAttachmentList(context, reportText, (List<Uri>)attachments);
        if (Build.VERSION.SDK_INT >= 29) {
            this.sendWithSelector(subject, body, attachments, context, contentAttached, bodyPrefix);
        } else {
            this.sendLegacy(subject, body, attachments, context, contentAttached, bodyPrefix);
        }
    }

    private void sendLegacy(String subject, String body, ArrayList<Uri> attachments, Context context, boolean contentAttached, String bodyPrefix) {
        PackageManager pm = context.getPackageManager();
        Intent resolveIntent = this.buildResolveIntent();
        ComponentName resolveActivity = resolveIntent.resolveActivity(pm);
        if (resolveActivity != null) {
            if (attachments.size() == 0) {
                context.startActivity(this.buildFallbackIntent(subject, body));
            } else {
                Intent attachmentIntent = this.buildAttachmentIntent(subject, contentAttached ? bodyPrefix : body, attachments);
                PackageManager packageManager = pm;
                Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"pm");
                List<Intent> initialIntents = this.buildInitialIntents(packageManager, resolveIntent, attachmentIntent);
                String packageName = this.getPackageName(resolveActivity, initialIntents);
                attachmentIntent.setPackage(packageName);
                if (packageName == null) {
                    for (Intent intent : initialIntents) {
                        this.grantPermission(context, intent, intent.getPackage(), (List<? extends Uri>)attachments);
                    }
                    this.showChooser(context, CollectionsKt.toMutableList((Collection)initialIntents));
                } else if (attachmentIntent.resolveActivity(pm) != null) {
                    this.grantPermission(context, attachmentIntent, packageName, (List<? extends Uri>)attachments);
                    context.startActivity(attachmentIntent);
                } else {
                    boolean $i$f$warn = false;
                    String string = ACRA.LOG_TAG;
                    ACRALog aCRALog = ACRA.log;
                    boolean bl = false;
                    String string2 = "No email client supporting attachments found. Attachments will be ignored";
                    aCRALog.w(string, string2);
                    context.startActivity(this.buildFallbackIntent(subject, body));
                }
            }
        } else {
            throw (Throwable)new ReportSenderException("No email client found");
        }
    }

    @RequiresApi(value=15)
    private void sendWithSelector(String subject, String body, ArrayList<Uri> attachments, Context context, boolean contentAttached, String bodyPrefix) {
        Intent intent = this.buildAttachmentIntent(subject, contentAttached ? bodyPrefix : body, attachments);
        this.grantPermission(context, intent, null, (List<? extends Uri>)attachments);
        intent.setSelector(this.buildResolveIntent());
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            throw (Throwable)new ReportSenderException("No email client found", (Throwable)e);
        }
    }

    public boolean requiresForeground() {
        return Build.VERSION.SDK_INT >= 29;
    }

    private String getPackageName(ComponentName resolveActivity, List<? extends Intent> initialIntents) {
        String packageName = resolveActivity.getPackageName();
        if (Intrinsics.areEqual((Object)packageName, (Object)"android")) {
            if (initialIntents.size() > 1) {
                packageName = null;
            } else if (initialIntents.size() == 1) {
                packageName = initialIntents.get(0).getPackage();
            }
        }
        return packageName;
    }

    @NotNull
    protected Intent buildAttachmentIntent(@NotNull String subject, @Nullable String body, @NotNull ArrayList<Uri> attachments) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.putExtra("android.intent.extra.EMAIL", new String[]{this.mailConfig.getMailTo()});
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", attachments);
        intent.putExtra("android.intent.extra.TEXT", (Serializable)CollectionsKt.arrayListOf((Object[])new String[]{body}));
        return intent;
    }

    @NotNull
    protected Intent buildResolveIntent() {
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)"mailto:"));
        intent.addFlags(0x10000000);
        return intent;
    }

    @NotNull
    protected Intent buildFallbackIntent(@NotNull String subject, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intent intent = new Intent("android.intent.action.SENDTO");
        intent.setData(Uri.parse((String)("mailto:" + this.mailConfig.getMailTo() + "?subject=" + Uri.encode((String)subject) + "&body=" + Uri.encode((String)body))));
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SUBJECT", subject);
        intent.putExtra("android.intent.extra.TEXT", body);
        return intent;
    }

    private List<Intent> buildInitialIntents(PackageManager pm, Intent resolveIntent, Intent emailIntent) {
        List list = pm.queryIntentActivities(resolveIntent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pm.queryIntentActivities\u2026nager.MATCH_DEFAULT_ONLY)");
        List resolveInfoList = list;
        List initialIntents = new ArrayList();
        for (ResolveInfo info : resolveInfoList) {
            Intent packageSpecificIntent = new Intent(emailIntent);
            packageSpecificIntent.setPackage(info.activityInfo.packageName);
            if (packageSpecificIntent.resolveActivity(pm) == null) continue;
            initialIntents.add(packageSpecificIntent);
        }
        return initialIntents;
    }

    private void showChooser(Context context, List<Intent> initialIntents) {
        Intent chooser = new Intent("android.intent.action.CHOOSER");
        chooser.putExtra("android.intent.extra.INTENT", (Parcelable)initialIntents.remove(0));
        Collection $this$toTypedArray$iv = initialIntents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intent[] intentArray = thisCollection$iv.toArray(new Intent[0]);
        if (intentArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        chooser.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])intentArray);
        chooser.addFlags(0x10000000);
        context.startActivity(chooser);
    }

    private void grantPermission(Context context, Intent intent, String packageName, List<? extends Uri> attachments) {
        if (Build.VERSION.SDK_INT >= 21) {
            Intrinsics.checkNotNullExpressionValue((Object)intent.addFlags(1), (String)"intent.addFlags(Intent.F\u2026RANT_READ_URI_PERMISSION)");
        } else {
            for (Uri uri : attachments) {
                context.grantUriPermission(packageName, uri, 1);
            }
        }
    }

    @NotNull
    protected String buildSubject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String subject = this.mailConfig.getSubject();
        CharSequence charSequence = subject;
        boolean bl = false;
        return charSequence.length() > 0 ? subject : context.getPackageName() + " Crash Report";
    }

    protected boolean fillAttachmentList(@NotNull Context context, @NotNull String reportText, @NotNull List<Uri> attachments) {
        Uri report;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        attachments.addAll(((AttachmentUriProvider)InstanceCreator.create((Class)this.config.getAttachmentUriProvider(), (Function0)fillAttachmentList.1.INSTANCE)).getAttachments(context, this.config));
        if (this.mailConfig.getReportAsFile() && (report = this.createAttachmentFromString(context, this.mailConfig.getReportFileName(), reportText)) != null) {
            attachments.add(report);
            return true;
        }
        return false;
    }

    @Nullable
    protected Uri createAttachmentFromString(@NotNull Context context, @NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File cache = new File(context.getCacheDir(), name);
        try {
            IOUtils.writeStringToFile((File)cache, (String)content);
            return AcraContentProvider.Companion.getUriForFile(context, cache);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public EmailIntentSender(@NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.mailConfig = (MailSenderConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)this.config, MailSenderConfiguration.class);
    }

    public void send(@NotNull Context context, @NotNull CrashReportData errorContent, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        ReportSender.DefaultImpls.send((ReportSender)this, (Context)context, (CrashReportData)errorContent, (Bundle)extras);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/acra/sender/EmailIntentSender$Companion;", "", "()V", "DEFAULT_REPORT_FILENAME", "", "acra-mail_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

