/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import org.acra.annotation.AcraNotification;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.NotificationConfiguration;
import org.acra.config.NotificationConfigurationBuilder;

final class NotificationConfigurationBuilderImpl
implements NotificationConfigurationBuilder {
    @NonNull
    private final Context context;
    private boolean enabled;
    @DrawableRes
    private int resIcon;
    @Nullable
    private String title;
    @Nullable
    private String text;
    @Nullable
    private String tickerText;
    @NonNull
    private String sendButtonText;
    @DrawableRes
    private int resSendButtonIcon;
    @NonNull
    private String discardButtonText;
    @DrawableRes
    private int resDiscardButtonIcon;
    @Nullable
    private String channelName;
    @Nullable
    private String channelDescription;
    private int resChannelImportance;
    @Nullable
    private String sendWithCommentButtonText;
    @DrawableRes
    private int resSendWithCommentButtonIcon;
    @Nullable
    private String commentPrompt;
    private boolean sendOnClick;

    NotificationConfigurationBuilderImpl(@NonNull Context arg0) {
        AcraNotification annotation = arg0.getClass().getAnnotation(AcraNotification.class);
        this.context = arg0;
        boolean bl = this.enabled = annotation != null;
        if (this.enabled) {
            this.resIcon = annotation.resIcon();
            if (annotation.resTitle() != 0) {
                this.title = this.context.getString(annotation.resTitle());
            }
            if (annotation.resText() != 0) {
                this.text = this.context.getString(annotation.resText());
            }
            if (annotation.resTickerText() != 0) {
                this.tickerText = this.context.getString(annotation.resTickerText());
            }
            if (annotation.resSendButtonText() != 0) {
                this.sendButtonText = this.context.getString(annotation.resSendButtonText());
            }
            this.resSendButtonIcon = annotation.resSendButtonIcon();
            if (annotation.resDiscardButtonText() != 0) {
                this.discardButtonText = this.context.getString(annotation.resDiscardButtonText());
            }
            this.resDiscardButtonIcon = annotation.resDiscardButtonIcon();
            if (annotation.resChannelName() != 0) {
                this.channelName = this.context.getString(annotation.resChannelName());
            }
            if (annotation.resChannelDescription() != 0) {
                this.channelDescription = this.context.getString(annotation.resChannelDescription());
            }
            this.resChannelImportance = annotation.resChannelImportance();
            if (annotation.resSendWithCommentButtonText() != 0) {
                this.sendWithCommentButtonText = this.context.getString(annotation.resSendWithCommentButtonText());
            }
            this.resSendWithCommentButtonIcon = annotation.resSendWithCommentButtonIcon();
            if (annotation.resCommentPrompt() != 0) {
                this.commentPrompt = this.context.getString(annotation.resCommentPrompt());
            }
            this.sendOnClick = annotation.sendOnClick();
        } else {
            this.resIcon = 17301642;
            this.sendButtonText = this.context.getString(17039370);
            this.resSendButtonIcon = 17301584;
            this.discardButtonText = this.context.getString(0x1040000);
            this.resDiscardButtonIcon = 17301564;
            this.resChannelImportance = 4;
            this.resSendWithCommentButtonIcon = 17301584;
            this.sendOnClick = false;
        }
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    boolean enabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResIcon(@DrawableRes int resIcon) {
        this.resIcon = resIcon;
        return this;
    }

    @DrawableRes
    int resIcon() {
        return this.resIcon;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResTitle(@StringRes int resTitle) {
        this.title = this.context.getString(resTitle);
        return this;
    }

    @Nullable
    String title() {
        return this.title;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setText(@Nullable String text) {
        this.text = text;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResText(@StringRes int resText) {
        this.text = this.context.getString(resText);
        return this;
    }

    @Nullable
    String text() {
        return this.text;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setTickerText(@Nullable String tickerText) {
        this.tickerText = tickerText;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResTickerText(@StringRes int resTickerText) {
        this.tickerText = this.context.getString(resTickerText);
        return this;
    }

    @Nullable
    String tickerText() {
        return this.tickerText;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setSendButtonText(@NonNull String sendButtonText) {
        this.sendButtonText = sendButtonText;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResSendButtonText(@StringRes int resSendButtonText) {
        this.sendButtonText = this.context.getString(resSendButtonText);
        return this;
    }

    @NonNull
    String sendButtonText() {
        return this.sendButtonText;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResSendButtonIcon(@DrawableRes int resSendButtonIcon) {
        this.resSendButtonIcon = resSendButtonIcon;
        return this;
    }

    @DrawableRes
    int resSendButtonIcon() {
        return this.resSendButtonIcon;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setDiscardButtonText(@NonNull String discardButtonText) {
        this.discardButtonText = discardButtonText;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResDiscardButtonText(@StringRes int resDiscardButtonText) {
        this.discardButtonText = this.context.getString(resDiscardButtonText);
        return this;
    }

    @NonNull
    String discardButtonText() {
        return this.discardButtonText;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResDiscardButtonIcon(@DrawableRes int resDiscardButtonIcon) {
        this.resDiscardButtonIcon = resDiscardButtonIcon;
        return this;
    }

    @DrawableRes
    int resDiscardButtonIcon() {
        return this.resDiscardButtonIcon;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setChannelName(@Nullable String channelName) {
        this.channelName = channelName;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResChannelName(@StringRes int resChannelName) {
        this.channelName = this.context.getString(resChannelName);
        return this;
    }

    @Nullable
    String channelName() {
        return this.channelName;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setChannelDescription(@Nullable String channelDescription) {
        this.channelDescription = channelDescription;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResChannelDescription(@StringRes int resChannelDescription) {
        this.channelDescription = this.context.getString(resChannelDescription);
        return this;
    }

    @Nullable
    String channelDescription() {
        return this.channelDescription;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResChannelImportance(int resChannelImportance) {
        this.resChannelImportance = resChannelImportance;
        return this;
    }

    int resChannelImportance() {
        return this.resChannelImportance;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setSendWithCommentButtonText(@Nullable String sendWithCommentButtonText) {
        this.sendWithCommentButtonText = sendWithCommentButtonText;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResSendWithCommentButtonText(@StringRes int resSendWithCommentButtonText) {
        this.sendWithCommentButtonText = this.context.getString(resSendWithCommentButtonText);
        return this;
    }

    @Nullable
    String sendWithCommentButtonText() {
        return this.sendWithCommentButtonText;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResSendWithCommentButtonIcon(@DrawableRes int resSendWithCommentButtonIcon) {
        this.resSendWithCommentButtonIcon = resSendWithCommentButtonIcon;
        return this;
    }

    @DrawableRes
    int resSendWithCommentButtonIcon() {
        return this.resSendWithCommentButtonIcon;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setCommentPrompt(@Nullable String commentPrompt) {
        this.commentPrompt = commentPrompt;
        return this;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setResCommentPrompt(@StringRes int resCommentPrompt) {
        this.commentPrompt = this.context.getString(resCommentPrompt);
        return this;
    }

    @Nullable
    String commentPrompt() {
        return this.commentPrompt;
    }

    @Override
    @NonNull
    public NotificationConfigurationBuilderImpl setSendOnClick(boolean sendOnClick) {
        this.sendOnClick = sendOnClick;
        return this;
    }

    boolean sendOnClick() {
        return this.sendOnClick;
    }

    @NonNull
    public NotificationConfiguration build() throws ACRAConfigurationException {
        if (this.enabled) {
            if (this.title == null) {
                throw new ACRAConfigurationException("title has to be set");
            }
            if (this.text == null) {
                throw new ACRAConfigurationException("text has to be set");
            }
            if (this.channelName == null) {
                throw new ACRAConfigurationException("channelName has to be set");
            }
        }
        return new NotificationConfiguration(this);
    }
}

