/*
 * Decompiled with CFR 0.152.
 */
package org.acra.interaction;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.widget.RemoteViews;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import java.io.File;
import java.io.Serializable;
import org.acra.config.ConfigUtils;
import org.acra.config.CoreConfiguration;
import org.acra.config.NotificationConfiguration;
import org.acra.interaction.ReportInteraction;
import org.acra.notification.R;
import org.acra.plugins.HasConfigPlugin;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.receiver.NotificationBroadcastReceiver;

public class NotificationInteraction
extends HasConfigPlugin
implements ReportInteraction {
    public static final String INTENT_ACTION_SEND = "org.acra.intent.send";
    public static final String INTENT_ACTION_DISCARD = "org.acra.intent.discard";
    public static final String KEY_COMMENT = "comment";
    public static final String EXTRA_REPORT_FILE = "REPORT_FILE";
    public static final int NOTIFICATION_ID = 666;
    private static final int ACTION_SEND = 667;
    private static final int ACTION_DISCARD = 668;
    private static final String CHANNEL = "ACRA";

    public NotificationInteraction() {
        super(NotificationConfiguration.class);
    }

    public boolean performInteraction(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull File reportFile) {
        SharedPreferences prefs = new SharedPreferencesFactory(context, config).create();
        if (prefs.getBoolean("acra.alwaysaccept", false)) {
            return true;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager == null) {
            return true;
        }
        NotificationConfiguration notificationConfig = (NotificationConfiguration)ConfigUtils.getPluginConfiguration((CoreConfiguration)config, NotificationConfiguration.class);
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL, (CharSequence)notificationConfig.channelName(), notificationConfig.resChannelImportance());
            channel.setSound(null, null);
            if (notificationConfig.channelDescription() != null) {
                channel.setDescription(notificationConfig.channelDescription());
            }
            notificationManager.createNotificationChannel(channel);
        }
        NotificationCompat.Builder notification = new NotificationCompat.Builder(context, CHANNEL).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)notificationConfig.title()).setContentText((CharSequence)notificationConfig.text()).setSmallIcon(notificationConfig.resIcon()).setPriority(1);
        if (notificationConfig.tickerText() != null) {
            notification.setTicker((CharSequence)notificationConfig.tickerText());
        }
        PendingIntent sendIntent = this.getSendIntent(context, config, reportFile);
        PendingIntent discardIntent = this.getDiscardIntent(context);
        if (Build.VERSION.SDK_INT >= 24 && notificationConfig.sendWithCommentButtonText() != null) {
            RemoteInput.Builder remoteInput = new RemoteInput.Builder(KEY_COMMENT);
            if (notificationConfig.commentPrompt() != null) {
                remoteInput.setLabel((CharSequence)notificationConfig.commentPrompt());
            }
            notification.addAction(new NotificationCompat.Action.Builder(notificationConfig.resSendWithCommentButtonIcon(), (CharSequence)notificationConfig.sendWithCommentButtonText(), sendIntent).addRemoteInput(remoteInput.build()).build());
        }
        if (Build.VERSION.SDK_INT >= 16) {
            RemoteViews bigView = this.getBigView(context, notificationConfig);
            notification.addAction(notificationConfig.resSendButtonIcon(), (CharSequence)notificationConfig.sendButtonText(), sendIntent).addAction(notificationConfig.resDiscardButtonIcon(), (CharSequence)notificationConfig.discardButtonText(), discardIntent).setCustomContentView(this.getSmallView(context, notificationConfig, sendIntent, discardIntent)).setCustomBigContentView(bigView).setCustomHeadsUpContentView(bigView).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle());
        }
        if (notificationConfig.sendOnClick() || Build.VERSION.SDK_INT < 16) {
            notification.setContentIntent(sendIntent);
        }
        notification.setDeleteIntent(discardIntent);
        notificationManager.notify(666, notification.build());
        return false;
    }

    private PendingIntent getSendIntent(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull File reportFile) {
        Intent intent = new Intent(context, NotificationBroadcastReceiver.class);
        intent.setAction(INTENT_ACTION_SEND);
        intent.putExtra("acraConfig", (Serializable)config);
        intent.putExtra(EXTRA_REPORT_FILE, (Serializable)reportFile);
        return PendingIntent.getBroadcast((Context)context, (int)667, (Intent)intent, (int)0x8000000);
    }

    private PendingIntent getDiscardIntent(@NonNull Context context) {
        Intent intent = new Intent(context, NotificationBroadcastReceiver.class);
        intent.setAction(INTENT_ACTION_DISCARD);
        return PendingIntent.getBroadcast((Context)context, (int)668, (Intent)intent, (int)0x8000000);
    }

    @NonNull
    private RemoteViews getSmallView(@NonNull Context context, @NonNull NotificationConfiguration notificationConfig, @NonNull PendingIntent sendIntent, @NonNull PendingIntent discardIntent) {
        RemoteViews view = new RemoteViews(context.getPackageName(), R.layout.notification_small);
        view.setTextViewText(R.id.text, (CharSequence)notificationConfig.text());
        view.setTextViewText(R.id.title, (CharSequence)notificationConfig.title());
        view.setImageViewResource(R.id.button_send, notificationConfig.resSendButtonIcon());
        view.setImageViewResource(R.id.button_discard, notificationConfig.resDiscardButtonIcon());
        view.setOnClickPendingIntent(R.id.button_send, sendIntent);
        view.setOnClickPendingIntent(R.id.button_discard, discardIntent);
        return view;
    }

    @NonNull
    private RemoteViews getBigView(@NonNull Context context, @NonNull NotificationConfiguration notificationConfig) {
        RemoteViews view = new RemoteViews(context.getPackageName(), R.layout.notification_big);
        view.setTextViewText(R.id.text, (CharSequence)notificationConfig.text());
        view.setTextViewText(R.id.title, (CharSequence)notificationConfig.title());
        return view;
    }
}

