/*
 * Decompiled with CFR 0.152.
 */
package org.acra.receiver;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.core.app.RemoteInput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.file.BulkReportDeleter;
import org.acra.file.CrashReportPersister;
import org.acra.scheduler.SchedulerStarter;
import org.acra.util.SystemServices;
import org.json.JSONException;

public class NotificationBroadcastReceiver
extends BroadcastReceiver {
    public void onReceive(@NonNull Context context, @NonNull Intent intent) {
        block15: {
            try {
                NotificationManager notificationManager = SystemServices.getNotificationManager((Context)context);
                notificationManager.cancel(666);
                if (intent.getAction() == null) break block15;
                switch (intent.getAction()) {
                    case "org.acra.intent.send": {
                        CharSequence comment;
                        Serializable reportFileObject = intent.getSerializableExtra("REPORT_FILE");
                        Serializable configObject = intent.getSerializableExtra("acraConfig");
                        if (!(configObject instanceof CoreConfiguration) || !(reportFileObject instanceof File)) break;
                        CoreConfiguration config = (CoreConfiguration)configObject;
                        File reportFile = (File)reportFileObject;
                        Bundle remoteInput = RemoteInput.getResultsFromIntent((Intent)intent);
                        if (remoteInput != null && (comment = remoteInput.getCharSequence("comment")) != null && !"".equals(comment.toString())) {
                            CrashReportPersister persister = new CrashReportPersister();
                            try {
                                if (ACRA.DEV_LOGGING) {
                                    ACRA.log.d(ACRA.LOG_TAG, "Add user comment to " + reportFile);
                                }
                                CrashReportData crashData = persister.load(reportFile);
                                crashData.put(ReportField.USER_COMMENT, comment.toString());
                                persister.store(crashData, reportFile);
                            }
                            catch (IOException | JSONException e) {
                                ACRA.log.w(ACRA.LOG_TAG, "User comment not added: ", e);
                            }
                        }
                        new SchedulerStarter(context, config).scheduleReports(reportFile, false);
                        break;
                    }
                    case "org.acra.intent.discard": {
                        if (ACRA.DEV_LOGGING) {
                            ACRA.log.d(ACRA.LOG_TAG, "Discarding reports");
                        }
                        new BulkReportDeleter(context).deleteReports(false, 0);
                    }
                }
            }
            catch (Exception t) {
                ACRA.log.e(ACRA.LOG_TAG, "Failed to handle notification action", (Throwable)t);
            }
        }
    }
}

