/*
 * Decompiled with CFR 0.152.
 */
package ch.astorm.jotlmsg;

import ch.astorm.jotlmsg.OutlookMessageAttachment;
import ch.astorm.jotlmsg.OutlookMessageRecipient;
import ch.astorm.jotlmsg.io.MessagePropertiesChunk;
import ch.astorm.jotlmsg.io.StoragePropertiesChunk;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;

public class OutlookMessage {
    private String subject;
    private String plainTextBody;
    private String from;
    private List<String> replyTo;
    private Date sentDate;
    private final Map<OutlookMessageRecipient.Type, List<OutlookMessageRecipient>> recipients = new EnumMap<OutlookMessageRecipient.Type, List<OutlookMessageRecipient>>(OutlookMessageRecipient.Type.class);
    private final List<OutlookMessageAttachment> attachments = new ArrayList<OutlookMessageAttachment>(8);
    public static final String MIME_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z (z)";
    private static final Pattern MIXED_MAIL = Pattern.compile("[^\\s<>,/]+@[^\\s<>,/]+");
    private final long OFFSET = 11644473600000L;

    public OutlookMessage() {
    }

    public OutlookMessage(InputStream mapiMessageInputStream) throws IOException {
        this(new MAPIMessage(mapiMessageInputStream));
    }

    public OutlookMessage(File mapiMessageFile) throws IOException {
        this(new MAPIMessage(mapiMessageFile));
    }

    public OutlookMessage(MAPIMessage mapiMessage) {
        this.parseMAPIMessage(mapiMessage);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPlainTextBody() {
        return this.plainTextBody;
    }

    public void setPlainTextBody(String plainTextBody) {
        this.plainTextBody = plainTextBody;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public List<String> getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(List<String> replyTo) {
        this.replyTo = replyTo;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date d) {
        this.sentDate = d;
    }

    public List<OutlookMessageRecipient> getRecipients(OutlookMessageRecipient.Type type) {
        return Collections.unmodifiableList(this.recipients.getOrDefault((Object)type, new ArrayList(0)));
    }

    public List<OutlookMessageRecipient> getAllRecipients() {
        ArrayList<OutlookMessageRecipient> allRecipients = new ArrayList<OutlookMessageRecipient>(16);
        this.recipients.forEach((k, v) -> allRecipients.addAll((Collection<OutlookMessageRecipient>)v));
        return allRecipients;
    }

    public OutlookMessageRecipient addRecipient(OutlookMessageRecipient.Type type, String email) {
        return this.addRecipient(type, email, null);
    }

    public OutlookMessageRecipient addRecipient(OutlookMessageRecipient.Type type, String email, String name) {
        OutlookMessageRecipient recipient = new OutlookMessageRecipient(type, email, name);
        this.addRecipient(recipient);
        return recipient;
    }

    public void addRecipient(OutlookMessageRecipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient is not defined");
        }
        List<OutlookMessageRecipient> typeRecipients = this.recipients.get((Object)recipient.getType());
        if (typeRecipients == null) {
            typeRecipients = new ArrayList<OutlookMessageRecipient>(31);
            this.recipients.put(recipient.getType(), typeRecipients);
        }
        typeRecipients.add(recipient);
    }

    public void removeRecipient(OutlookMessageRecipient recipient) {
        List<OutlookMessageRecipient> typeRecipients = this.recipients.get((Object)recipient.getType());
        if (typeRecipients != null) {
            typeRecipients.remove(recipient);
        }
    }

    public void removeAllRecipients(OutlookMessageRecipient.Type type) {
        this.recipients.remove((Object)type);
    }

    public void removeAllRecipients() {
        this.recipients.clear();
    }

    public List<OutlookMessageAttachment> getAttachments() {
        return this.attachments;
    }

    public OutlookMessageAttachment addAttachment(String name, String mimeType, InputStream input) {
        OutlookMessageAttachment attachment = new OutlookMessageAttachment(name, mimeType, input);
        this.addAttachment(attachment);
        return attachment;
    }

    public OutlookMessageAttachment addAttachment(String name, String mimeType, OutlookMessageAttachment.InputStreamCreator inputStreamCreator) {
        OutlookMessageAttachment attachment = new OutlookMessageAttachment(name, mimeType, inputStreamCreator);
        this.addAttachment(attachment);
        return attachment;
    }

    public void addAttachment(OutlookMessageAttachment attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment is not defined");
        }
        this.attachments.add(attachment);
    }

    public void removeAttachment(OutlookMessageAttachment attachment) {
        this.attachments.remove(attachment);
    }

    public void removeAllAttachments() {
        this.attachments.clear();
    }

    public MimeMessage toMimeMessage() throws IOException, MessagingException {
        return this.toMimeMessage(new Properties());
    }

    public MimeMessage toMimeMessage(Properties sessionProps) throws IOException, MessagingException {
        Session session = Session.getInstance((Properties)sessionProps);
        return this.toMimeMessage(session);
    }

    public MimeMessage toMimeMessage(Session session) throws IOException, MessagingException {
        List<String> replyTo;
        String from;
        MimeMessage message = new MimeMessage(session);
        message.setSentDate(this.sentDate);
        String subject = this.getSubject();
        if (subject != null) {
            message.setSubject(subject);
        }
        if ((from = OutlookMessage.extractEmail(this.getFrom())) != null) {
            message.setFrom((Address)new InternetAddress(from));
        }
        if ((replyTo = this.getReplyTo()) != null) {
            ArrayList replyAddresses = new ArrayList(replyTo.size());
            for (String replyToEmail : replyTo) {
                String replyToEmailExtracted = OutlookMessage.extractEmail(replyToEmail);
                if (replyToEmailExtracted == null) continue;
                replyAddresses.add(new InternetAddress(replyToEmailExtracted));
            }
            message.setReplyTo(replyAddresses.toArray(new Address[replyAddresses.size()]));
        }
        for (OutlookMessageRecipient recipient : this.getAllRecipients()) {
            Address address = recipient.getAddress();
            if (address == null) continue;
            message.addRecipient(recipient.getType().getRecipientType(), address);
        }
        MimeMultipart multipart = new MimeMultipart();
        String plainText = this.getPlainTextBody();
        if (plainText == null) {
            throw new MessagingException("missing body");
        }
        MimeBodyPart body = new MimeBodyPart();
        body.setFileName("body");
        body.setText(this.getPlainTextBody(), StandardCharsets.UTF_8.name(), "plain");
        multipart.addBodyPart((BodyPart)body);
        for (OutlookMessageAttachment attachment : this.getAttachments()) {
            String name = attachment.getName();
            String mimeType = attachment.getMimeType();
            byte[] data = this.readAttachement(attachment);
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, mimeType)));
            part.setFileName(name);
            multipart.addBodyPart((BodyPart)part);
        }
        message.setContent((Multipart)multipart);
        return message;
    }

    public static String extractEmail(String mixedMailStr) {
        if (mixedMailStr == null || mixedMailStr.trim().isEmpty()) {
            return null;
        }
        Matcher matcher = MIXED_MAIL.matcher(mixedMailStr);
        return matcher.find() ? matcher.group() : null;
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.writeTo(fos);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        DirectoryEntry recip;
        String rid;
        byte[] byArray;
        POIFSFileSystem fs = new POIFSFileSystem();
        List<OutlookMessageRecipient> recipients = this.getAllRecipients();
        List<OutlookMessageAttachment> attachments = this.getAttachments();
        String body = this.getPlainTextBody();
        String subject = this.getSubject();
        String from = this.getFrom();
        DirectoryEntry nameid = fs.createDirectory("__nameid_version1.0");
        nameid.createDocument("__substg1.0_00020102", (InputStream)new ByteArrayInputStream(new byte[0]));
        nameid.createDocument("__substg1.0_00030102", (InputStream)new ByteArrayInputStream(new byte[0]));
        nameid.createDocument("__substg1.0_00040102", (InputStream)new ByteArrayInputStream(new byte[0]));
        MessagePropertiesChunk topLevelChunk = new MessagePropertiesChunk();
        topLevelChunk.setAttachmentCount(attachments.size());
        topLevelChunk.setRecipientCount(recipients.size());
        topLevelChunk.setNextAttachmentId(attachments.size());
        topLevelChunk.setNextRecipientId(recipients.size());
        topLevelChunk.setProperty(new PropertyValue(MAPIProperty.STORE_SUPPORT_MASK, 6L, ByteBuffer.allocate(4).putInt(262144).array()));
        topLevelChunk.setProperty(new PropertyValue(MAPIProperty.MESSAGE_CLASS, 6L, StringUtil.getToUnicodeLE((String)"IPM.Note")));
        if (attachments.isEmpty()) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 1;
        }
        topLevelChunk.setProperty(new PropertyValue(MAPIProperty.HASATTACH, 6L, byArray));
        if (this.sentDate == null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.MESSAGE_FLAGS, 6L, ByteBuffer.allocate(4).putInt(8).array()));
        } else {
            SimpleDateFormat mdf = new SimpleDateFormat(MIME_DATE_FORMAT);
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.MESSAGE_FLAGS, 6L, ByteBuffer.allocate(4).putInt(2).array()));
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.CLIENT_SUBMIT_TIME, 6L, this.dateToBytes(this.sentDate)));
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.TRANSPORT_MESSAGE_HEADERS, 6L, StringUtil.getToUnicodeLE((String)("Date: " + mdf.format(this.sentDate)))));
        }
        if (subject != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.SUBJECT, 6L, StringUtil.getToUnicodeLE((String)subject)));
        }
        if (body != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.BODY, 6L, StringUtil.getToUnicodeLE((String)body)));
        }
        if (from != null) {
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.SENDER_EMAIL_ADDRESS, 6L, StringUtil.getToUnicodeLE((String)from)));
            topLevelChunk.setProperty(new PropertyValue(MAPIProperty.SENDER_NAME, 6L, StringUtil.getToUnicodeLE((String)from)));
        }
        topLevelChunk.writeTo((DirectoryEntry)fs.getRoot());
        int recipientCounter = 0;
        for (OutlookMessageRecipient recipient : recipients) {
            if (recipientCounter >= 2048) {
                throw new RuntimeException("too many recipients (max=2048)");
            }
            String name = recipient.getName();
            String email = recipient.getEmail();
            OutlookMessageRecipient.Type type = recipient.getType();
            int rt = type == OutlookMessageRecipient.Type.TO ? 1 : (type == OutlookMessageRecipient.Type.CC ? 2 : 3);
            StoragePropertiesChunk recipStorage = new StoragePropertiesChunk();
            recipStorage.setProperty(new PropertyValue(MAPIProperty.OBJECT_TYPE, 6L, ByteBuffer.allocate(4).putInt(6).array()));
            recipStorage.setProperty(new PropertyValue(MAPIProperty.DISPLAY_TYPE, 6L, ByteBuffer.allocate(4).putInt(0).array()));
            recipStorage.setProperty(new PropertyValue(MAPIProperty.RECIPIENT_TYPE, 6L, ByteBuffer.allocate(4).putInt(rt).array()));
            recipStorage.setProperty(new PropertyValue(MAPIProperty.ROWID, 6L, ByteBuffer.allocate(4).putInt(recipientCounter).array()));
            if (name != null) {
                recipStorage.setProperty(new PropertyValue(MAPIProperty.DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)name)));
                recipStorage.setProperty(new PropertyValue(MAPIProperty.RECIPIENT_DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)name)));
            }
            if (email != null) {
                recipStorage.setProperty(new PropertyValue(MAPIProperty.EMAIL_ADDRESS, 6L, StringUtil.getToUnicodeLE((String)email)));
                if (name == null) {
                    recipStorage.setProperty(new PropertyValue(MAPIProperty.DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)email)));
                    recipStorage.setProperty(new PropertyValue(MAPIProperty.RECIPIENT_DISPLAY_NAME, 6L, StringUtil.getToUnicodeLE((String)email)));
                }
            }
            rid = "" + Integer.toHexString(recipientCounter);
            while (rid.length() < 8) {
                rid = "0" + rid;
            }
            recip = fs.createDirectory("__recip_version1.0_#" + rid);
            recipStorage.writeTo(recip);
            ++recipientCounter;
        }
        int attachmentCounter = 0;
        for (OutlookMessageAttachment attachment : attachments) {
            if (attachmentCounter >= 2048) {
                throw new RuntimeException("too many attachments (max=2048)");
            }
            String name = attachment.getName();
            String mimeType = attachment.getMimeType();
            byte[] data = this.readAttachement(attachment);
            StoragePropertiesChunk attachStorage = new StoragePropertiesChunk();
            attachStorage.setProperty(new PropertyValue(MAPIProperty.OBJECT_TYPE, 6L, ByteBuffer.allocate(4).putInt(7).array()));
            if (name != null) {
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_FILENAME, 6L, StringUtil.getToUnicodeLE((String)name)));
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_LONG_FILENAME, 6L, StringUtil.getToUnicodeLE((String)name)));
            }
            if (mimeType != null) {
                attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_MIME_TAG, 6L, StringUtil.getToUnicodeLE((String)name)));
            }
            attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_NUM, 6L, ByteBuffer.allocate(4).putInt(attachmentCounter).array()));
            attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_METHOD, 6L, ByteBuffer.allocate(4).putInt(1).array()));
            attachStorage.setProperty(new PropertyValue(MAPIProperty.ATTACH_DATA, 6L, data));
            rid = "" + Integer.toHexString(attachmentCounter);
            while (rid.length() < 8) {
                rid = "0" + rid;
            }
            recip = fs.createDirectory("__attach_version1.0_#" + rid);
            attachStorage.writeTo(recip);
            ++attachmentCounter;
        }
        fs.writeFilesystem(outputStream);
        fs.close();
    }

    private byte[] readAttachement(OutlookMessageAttachment attachment) throws IOException {
        try (InputStream is = attachment.getNewInputStream();){
            if (is == null) {
                throw new IllegalStateException("null inputstream for attachement " + attachment.getName() + " (" + attachment.getMimeType() + ")");
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    private byte[] dateToBytes(Date date) {
        return ByteBuffer.allocate(8).putLong((date.getTime() + 11644473600000L) * 10L * 1000L).array();
    }

    private void parseMAPIMessage(MAPIMessage mapiMessage) {
        this.silent(() -> this.parseHeaders(mapiMessage));
        this.silent(() -> this.parseFrom(mapiMessage));
        this.silent(() -> this.parseReplyTo(mapiMessage));
        this.silent(() -> this.parseSubject(mapiMessage));
        this.silent(() -> this.parseTextBody(mapiMessage));
        this.silent(() -> this.parseRecipients(mapiMessage));
        this.silent(() -> this.parseAttachments(mapiMessage));
    }

    protected void parseFrom(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.from = mapiMessage.getDisplayFrom();
        if (this.from != null) {
            this.from = this.from.trim();
        }
        if (this.from != null && this.from.isEmpty()) {
            this.from = null;
        }
    }

    protected void parseReplyTo(MAPIMessage mapiMessage) throws ChunkNotFoundException {
    }

    protected void parseSubject(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.subject = mapiMessage.getSubject();
        if (this.subject != null) {
            this.subject = this.subject.trim();
        }
        if (this.subject != null && this.subject.isEmpty()) {
            this.subject = null;
        }
    }

    protected void parseTextBody(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        this.plainTextBody = mapiMessage.getTextBody();
        if (this.plainTextBody != null) {
            this.plainTextBody = this.plainTextBody.trim();
        }
        if (this.plainTextBody != null && this.plainTextBody.isEmpty()) {
            this.plainTextBody = null;
        }
    }

    protected void parseRecipients(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        RecipientChunks[] recipientChunks;
        for (RecipientChunks recipientChunk : recipientChunks = mapiMessage.getRecipientDetailsChunks()) {
            String name = recipientChunk.getRecipientName();
            String email = recipientChunk.getRecipientEmailAddress();
            if (name != null && email != null && name.equals(email)) {
                name = null;
            }
            OutlookMessageRecipient.Type type = OutlookMessageRecipient.Type.TO;
            List values = (List)recipientChunk.getProperties().get(MAPIProperty.RECIPIENT_TYPE);
            if (values != null && !values.isEmpty()) {
                int value = (Integer)((PropertyValue)values.get(0)).getValue();
                if (value == 1) {
                    type = OutlookMessageRecipient.Type.TO;
                } else if (value == 2) {
                    type = OutlookMessageRecipient.Type.CC;
                } else if (value == 3) {
                    type = OutlookMessageRecipient.Type.BCC;
                }
            }
            this.addRecipient(type, email, name);
        }
    }

    protected void parseHeaders(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        List headerChunks = (List)mapiMessage.getMainChunks().getAll().get(MAPIProperty.TRANSPORT_MESSAGE_HEADERS);
        if (headerChunks != null && !headerChunks.isEmpty()) {
            for (Chunk chunk : headerChunks) {
                StringChunk sc;
                String value;
                int dateIdx;
                if (!(chunk instanceof StringChunk) || (dateIdx = (value = (sc = (StringChunk)chunk).getValue()).indexOf("Date:")) < 0) continue;
                int line = value.indexOf(10, dateIdx + 5);
                int semiColon = value.indexOf(59, dateIdx + 5);
                int limit = line >= 0 && semiColon >= 0 ? Math.min(line, semiColon) : (line >= 0 ? line : semiColon);
                String dateStr = value.substring(dateIdx + 5, limit >= 0 ? limit : value.length()).trim();
                SimpleDateFormat mdf = new SimpleDateFormat(MIME_DATE_FORMAT);
                try {
                    this.sentDate = mdf.parse(dateStr);
                }
                catch (ParseException parseException) {}
            }
        }
        if (this.sentDate == null) {
            Calendar msgDate = mapiMessage.getMessageDate();
            this.sentDate = msgDate.getTime();
        }
    }

    protected void parseAttachments(MAPIMessage mapiMessage) throws ChunkNotFoundException {
        AttachmentChunks[] attachmentChunks;
        for (AttachmentChunks attachmentChunk : attachmentChunks = mapiMessage.getAttachmentFiles()) {
            StringChunk longFileName = attachmentChunk.getAttachLongFileName();
            StringChunk fileName = attachmentChunk.getAttachFileName();
            ByteChunk data = attachmentChunk.getAttachData();
            StringChunk mimeType = attachmentChunk.getAttachMimeTag();
            String name = longFileName != null ? longFileName.getValue() : (fileName != null ? fileName.getValue() : attachmentChunk.getPOIFSName());
            ByteArrayInputStream dataIS = data != null ? new ByteArrayInputStream(data.getValue()) : null;
            String mimeTypeVal = mimeType != null ? mimeType.getValue() : null;
            this.addAttachment(name, mimeTypeVal, dataIS);
        }
    }

    private boolean silent(SilentCallFailure call) {
        try {
            call.invoke();
        }
        catch (ChunkNotFoundException ignored) {
            return false;
        }
        return true;
    }

    @FunctionalInterface
    private static interface SilentCallFailure {
        public void invoke() throws ChunkNotFoundException;
    }
}

