/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet;

import ch.bildspur.artnet.ArtNetBuffer;
import ch.bildspur.artnet.ArtNetException;
import ch.bildspur.artnet.ArtNetNode;
import ch.bildspur.artnet.ArtNetServer;
import ch.bildspur.artnet.events.ArtNetServerEventAdapter;
import ch.bildspur.artnet.packets.ArtDmxPacket;
import ch.bildspur.artnet.packets.ArtNetPacket;
import ch.bildspur.artnet.packets.PacketType;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ArtNetClient {
    private ArtNetServer server;
    private int sequenceId = 0;
    private boolean isRunning = false;
    private ArtNetBuffer inputBuffer;

    public ArtNetClient() {
        this(new ArtNetBuffer());
    }

    public ArtNetClient(ArtNetBuffer inputBuffer) {
        this(inputBuffer, 6454, 6454);
    }

    public ArtNetClient(ArtNetBuffer inputBuffer, int serverPort, int clientPort) {
        this.inputBuffer = inputBuffer;
        this.server = new ArtNetServer(serverPort, clientPort);
    }

    public void start() {
        this.start((InetAddress)null);
    }

    public void start(String networkInterfaceAddress) {
        try {
            this.start(InetAddress.getByName(networkInterfaceAddress));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void start(InetAddress networkInterfaceAddress) {
        if (this.isRunning) {
            return;
        }
        if (this.inputBuffer != null) {
            this.inputBuffer.clear();
        }
        try {
            this.server.addListener(new ArtNetServerEventAdapter(){

                @Override
                public void artNetPacketReceived(ArtNetPacket packet) {
                    ArtNetClient.this.onPacketReceived(packet);
                }
            });
            this.server.start(networkInterfaceAddress);
            this.isRunning = true;
        }
        catch (ArtNetException | SocketException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.server.stop();
        this.isRunning = false;
    }

    public void broadcastDmx(int subnet, int universe, byte[] dmxData) {
        this.server.broadcastPacket(this.createDmxPacket(subnet, universe, dmxData));
    }

    public void unicastDmx(String address, int subnet, int universe, byte[] dmxData) {
        try {
            this.unicastDmx(InetAddress.getByName(address), subnet, universe, dmxData);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public void unicastDmx(ArtNetNode node, int subnet, int universe, byte[] dmxData) {
        this.server.unicastPacket(this.createDmxPacket(subnet, universe, dmxData), node.getIPAddress());
    }

    public void unicastDmx(InetAddress address, int subnet, int universe, byte[] dmxData) {
        this.server.unicastPacket(this.createDmxPacket(subnet, universe, dmxData), address);
    }

    private ArtDmxPacket createDmxPacket(int subnet, int universe, byte[] dmxData) {
        ArtDmxPacket dmx = new ArtDmxPacket();
        dmx.setUniverse(subnet, universe);
        dmx.setSequenceID(++this.sequenceId);
        dmx.setDMX(dmxData, dmxData.length);
        this.sequenceId %= 256;
        return dmx;
    }

    private void onPacketReceived(ArtNetPacket packet) {
        if (this.inputBuffer == null) {
            return;
        }
        if (packet.getType() != PacketType.ART_OUTPUT) {
            return;
        }
        ArtDmxPacket dmxPacket = (ArtDmxPacket)packet;
        int subnet = dmxPacket.getSubnetID();
        int universe = dmxPacket.getUniverseID();
        this.inputBuffer.setDmxData((short)subnet, (short)universe, dmxPacket.getDmxData());
    }

    public byte[] readDmxData(int subnet, int universe) {
        return this.readDmxData((short)subnet, (short)universe);
    }

    public byte[] readDmxData(short subnet, short universe) {
        return this.inputBuffer.getDmxData(subnet, universe);
    }

    public ArtNetServer getArtNetServer() {
        return this.server;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public ArtNetBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(ArtNetBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }
}

