/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet;

import ch.bildspur.artnet.ArtNetNode;
import ch.bildspur.artnet.DmxUniverseConfig;
import ch.bildspur.artnet.packets.ArtDmxPacket;

public class DmxUniverse {
    protected final DmxUniverseConfig config;
    protected final byte[] frameData;
    protected ArtNetNode node;
    protected boolean isEnabled = true;
    protected boolean isActive = true;

    public DmxUniverse(ArtNetNode node, DmxUniverseConfig config) {
        this.node = node;
        this.config = config;
        this.frameData = new byte[512];
    }

    public DmxUniverseConfig getConfig() {
        return this.config;
    }

    public String getID() {
        return this.config.id;
    }

    public ArtNetNode getNode() {
        return this.node;
    }

    public int getNumChannels() {
        return this.config.numDmxChannels;
    }

    public ArtDmxPacket getPacket(int sequenceID) {
        ArtDmxPacket packet = new ArtDmxPacket();
        packet.setSequenceID(sequenceID);
        packet.setUniverse(this.node.getSubNet(), this.config.universeID);
        packet.setDMX(this.frameData, this.config.ignoreNumChannels ? 512 : this.config.numDmxChannels);
        return packet;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setChannel(int offset, int val) {
        this.frameData[offset] = (byte)val;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setNode(ArtNetNode node) {
        this.node = node;
    }

    public void setRGBPixel(int offset, int col) {
        this.frameData[offset *= 3] = (byte)(col >> 16 & 0xFF);
        this.frameData[offset + 1] = (byte)(col >> 8 & 0xFF);
        this.frameData[offset + 2] = (byte)(col & 0xFF);
    }

    public String toString() {
        return this.node.getIPAddress() + "u: " + this.config.universeID + " st: " + this.isEnabled + "/" + this.isActive + " c: " + this.config.numDmxChannels;
    }
}

