/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet.packets;

import ch.bildspur.artnet.packets.ArtNetPacket;
import ch.bildspur.artnet.packets.ByteUtils;
import ch.bildspur.artnet.packets.PacketType;
import java.util.Arrays;

public class ArtDmxPacket
extends ArtNetPacket {
    private int numChannels;
    private int sequenceID;
    private int subnetID;
    private int universeID;
    private byte[] dmxData;

    public ArtDmxPacket() {
        super(PacketType.ART_OUTPUT);
        this.setData(new byte[530]);
        this.setHeader();
        this.setProtocol();
        this.data.setInt8(2, 13);
    }

    public byte[] getDmxData() {
        return this.dmxData;
    }

    @Override
    public int getLength() {
        return 18 + (1 == this.numChannels % 2 ? this.numChannels + 1 : this.numChannels);
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getSequenceID() {
        return this.sequenceID;
    }

    public int getSubnetID() {
        return this.subnetID;
    }

    public int getUniverseID() {
        return this.universeID;
    }

    @Override
    public boolean parse(byte[] raw) {
        this.setData(raw);
        this.sequenceID = this.data.getInt8(12);
        int subnetUniverse = this.data.getInt8(14);
        this.subnetID = subnetUniverse >> 4;
        this.universeID = subnetUniverse & 0xF;
        this.numChannels = this.data.getInt16(16);
        this.dmxData = this.data.getByteChunk(this.dmxData, 18, this.numChannels);
        return true;
    }

    public void setDMX(byte[] dmxData, int numChannels) {
        logger.finer("setting DMX data for: " + numChannels + " channels");
        this.dmxData = Arrays.copyOf(dmxData, numChannels);
        this.numChannels = numChannels;
        this.data.setByteChunk(dmxData, 18, numChannels);
        this.data.setInt16(1 == numChannels % 2 ? numChannels + 1 : numChannels, 16);
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels > 512 ? 512 : numChannels;
    }

    public void setSequenceID(int id) {
        this.sequenceID = id % 255;
        this.data.setInt8(id, 12);
    }

    public void setSubnetID(int subnetID) {
        this.subnetID = subnetID & 0xF;
    }

    public void setUniverse(int subnetID, int universeID) {
        this.subnetID = subnetID & 0xF;
        this.universeID = universeID & 0xF;
        this.data.setInt16LE(subnetID << 4 | universeID, 14);
        logger.finer("universe ID set to: subnet: " + ByteUtils.hex(subnetID, 2) + "/" + ByteUtils.hex(universeID, 2));
    }

    public void setUniverseID(int universeID) {
        this.universeID = universeID & 0xF;
    }
}

