/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.artnet.packets;

import ch.bildspur.artnet.packets.ArtNetPacket;
import ch.bildspur.artnet.packets.PacketType;

public class ArtTimePacket
extends ArtNetPacket {
    private int frames;
    private int seconds;
    private int minutes;
    private int hours;
    private int type;

    public ArtTimePacket() {
        super(PacketType.ART_TIMECODE);
        this.setData(new byte[19]);
        this.setHeader();
        this.setProtocol();
    }

    @Override
    public boolean parse(byte[] raw) {
        this.setData(raw);
        this.frames = this.data.getInt8(14);
        this.seconds = this.data.getInt8(15);
        this.minutes = this.data.getInt8(16);
        this.hours = this.data.getInt8(17);
        this.type = this.data.getInt8(18);
        return true;
    }

    public void setTime(int hour, int min, int sec, int frame) {
        this.hours = hour;
        this.minutes = min;
        this.seconds = sec;
        this.frames = frame;
        this.updateData();
    }

    public int getFrames() {
        return this.frames;
    }

    public void setFrames(int frames) {
        this.frames = frames;
        this.updateData();
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
        this.updateData();
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
        this.updateData();
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
        this.updateData();
    }

    public int getFrameType() {
        return this.type;
    }

    public void setFrameType(int type) {
        this.type = type;
        this.updateData();
    }

    private void updateData() {
        this.data.setInt8(this.frames, 14);
        this.data.setInt8(this.seconds, 15);
        this.data.setInt8(this.minutes, 16);
        this.data.setInt8(this.hours, 17);
        this.data.setInt8(this.type, 18);
    }
}

