/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.eventbus;

import ch.cmbntr.eventbus.Handler;
import ch.cmbntr.eventbus.Handlers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Queues;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.DeadEvent;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class EventBus
implements Runnable {
    private static final ThreadLocal<Boolean> IS_DISPATCHING = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final SetMultimap<Class<?>, Handler> handlersByEventType = Multimaps.newSetMultimap((Map)new MapMaker().weakKeys().makeMap(), (Supplier)new Supplier<Set<Handler>>(){

        public Set<Handler> get() {
            return EventBus.this.newHandlerSet();
        }
    });
    private final LoadingCache<Class<?>, Set<Handler>> handlersByTargetType;
    private final Queue<Object> pending = Queues.newConcurrentLinkedQueue();
    private final Executor dispatcher;

    public EventBus() {
        this("default");
    }

    public EventBus(String identifier) {
        this(identifier, true, (Executor)MoreExecutors.sameThreadExecutor(), Executors.newSingleThreadExecutor());
    }

    public EventBus(String identifier, boolean batchDispatching, Executor handlerExecutor, Executor dispatcher) {
        this(Handlers.handlerBuilder(identifier, (Function<? super Method, ? extends Executor>)Functions.constant((Object)handlerExecutor), (Predicate<? super Method>)(batchDispatching ? Predicates.alwaysTrue() : Predicates.alwaysFalse())), dispatcher);
    }

    public EventBus(Function<? super Method, Handler> handlerBuilder, Executor dispatcher) {
        this(Handlers.IS_SUBSCRIBE_METHOD, handlerBuilder, dispatcher);
    }

    protected EventBus(Predicate<? super Method> isHandler, Function<? super Method, Handler> handlerBuilder, Executor dispatcher) {
        this.dispatcher = dispatcher;
        this.handlersByTargetType = Handlers.newHandlerCache(isHandler, this.handlerRegistration(handlerBuilder));
    }

    private Function<Method, Handler> handlerRegistration(final Function<? super Method, Handler> builder) {
        return new Function<Method, Handler>(){

            public Handler apply(Method m) {
                assert (m != null);
                Handler h = (Handler)builder.apply((Object)m);
                EventBus.this.registerHandler(m, h);
                return h;
            }
        };
    }

    protected Set<Handler> newHandlerSet() {
        return Sets.newCopyOnWriteArraySet();
    }

    private void registerHandler(Method m, Handler h) {
        this.handlersByEventType.put(m.getParameterTypes()[0], (Object)h);
    }

    protected void dispatch(Object event) {
        boolean dispatched = false;
        for (Class<?> eventType : Handlers.linearizeHierarchy(event.getClass())) {
            if (!this.handlersByEventType.containsKey(eventType)) continue;
            for (Handler h : this.handlersByEventType.get(eventType)) {
                dispatched |= h.dispatch(event);
            }
        }
        if (!dispatched && !(event instanceof DeadEvent)) {
            this.post(new DeadEvent((Object)this, event));
        }
    }

    public void post(Object event) {
        this.pending.add(event);
        if (!IS_DISPATCHING.get().booleanValue()) {
            this.dispatcher.execute(this);
        }
    }

    @Override
    public void run() {
        try {
            IS_DISPATCHING.set(Boolean.TRUE);
            while (true) {
                Object event;
                if ((event = this.pending.poll()) == null) {
                    return;
                }
                this.dispatch(event);
            }
        }
        finally {
            IS_DISPATCHING.set(Boolean.FALSE);
        }
    }

    private Set<Handler> getHandlersForTargetType(Class<? extends Object> targetType) {
        return (Set)this.handlersByTargetType.getUnchecked(targetType);
    }

    public void register(Object target) {
        for (Handler handler : this.getHandlersForTargetType(target.getClass())) {
            handler.register(target);
        }
    }

    public void registerWeak(Object target) {
        for (Handler handler : this.getHandlersForTargetType(target.getClass())) {
            handler.registerWeak(target);
        }
    }

    public void unregister(Object target) {
        for (Handler handler : this.getHandlersForTargetType(target.getClass())) {
            handler.unregister(target);
        }
    }
}

