/*
 * Decompiled with CFR 0.152.
 */
package ch.cmbntr.eventbus;

import ch.cmbntr.eventbus.Handler;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class Handlers {
    public static final Predicate<Method> IS_SUBSCRIBE_METHOD = Handlers.isHandlerMarkedWith(Subscribe.class);
    private static final Predicate<Method> CONCURRENT_DELIVERY = new Predicate<Method>(){

        public boolean apply(Method method) {
            assert (method != null);
            return method.getAnnotation(AllowConcurrentEvents.class) != null || Modifier.isSynchronized(method.getModifiers());
        }
    };
    private static final Function<Class<?>, List<Method>> GET_METHODS = new Function<Class<?>, List<Method>>(){

        public List<Method> apply(Class<?> clazz) {
            assert (clazz != null);
            return Arrays.asList(clazz.getMethods());
        }
    };
    private static final LoadingCache<Class<?>, Set<Class<?>>> HIERARCHIES = Handlers.weakKeyCache(new CacheLoader<Class<?>, Set<Class<?>>>(){

        public Set<Class<?>> load(Class<?> concreteClass) {
            return TypeToken.of(concreteClass).getTypes().rawTypes();
        }
    });
    private static final int WRITE_CONCURRENCY = 1;

    private Handlers() {
    }

    private static <K, V> LoadingCache<K, V> weakKeyCache(CacheLoader<? super K, V> loader) {
        return CacheBuilder.newBuilder().weakKeys().concurrencyLevel(1).build(loader);
    }

    public static LoadingCache<Class<?>, Set<Handler>> newHandlerCache(Predicate<? super Method> isHandler, Function<? super Method, Handler> builder) {
        return Handlers.weakKeyCache(CacheLoader.from((Function)Functions.compose(Handlers.filterAndBuild(isHandler, builder), GET_METHODS)));
    }

    private static Function<List<Method>, Set<Handler>> filterAndBuild(final Predicate<? super Method> isHandler, Function<? super Method, Handler> builder) {
        final LoadingCache cachedBuilder = Handlers.weakKeyCache(CacheLoader.from(builder));
        return new Function<List<Method>, Set<Handler>>(){

            public Set<Handler> apply(List<Method> methods) {
                assert (methods != null);
                return ImmutableSet.copyOf((Iterable)FluentIterable.from(methods).filter(isHandler).transform(cachedBuilder));
            }
        };
    }

    public static EventDelivery createDelivery(Method handler, boolean concurrent) {
        try {
            return Handlers.createDelivery(MethodHandles.publicLookup(), handler, concurrent);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static EventDelivery createDelivery(MethodHandles.Lookup lookup, Method h, boolean concurrent) throws IllegalAccessException {
        h.setAccessible(true);
        EventDelivery handler = MethodHandleProxies.asInterfaceInstance(EventDelivery.class, lookup.unreflect(h));
        return concurrent ? handler : new SynchronizedDelivery(handler);
    }

    public static Function<Method, Handler> handlerBuilder(String identifier, final Function<? super Method, ? extends Executor> deliveryExecutor, final Predicate<? super Method> batchDelivery) {
        final Logger logger = Logger.getLogger(EventHandler.class.getName() + "." + (String)Preconditions.checkNotNull((Object)identifier));
        return new Function<Method, Handler>(){

            public Handler apply(Method handler) {
                assert (handler != null);
                Executor exec = (Executor)deliveryExecutor.apply((Object)handler);
                boolean batching = batchDelivery.apply((Object)handler);
                boolean threadSafe = CONCURRENT_DELIVERY.apply((Object)handler);
                EventDelivery delivery = Handlers.createDelivery(handler, threadSafe);
                return EventHandler.create(logger, delivery, batching, exec);
            }
        };
    }

    public static Predicate<Method> isHandlerMarkedWith(final Class<? extends Annotation> marker) {
        return new Predicate<Method>(){

            public boolean apply(Method method) {
                assert (method != null);
                for (Class c : TypeToken.of(method.getDeclaringClass()).getTypes().rawTypes()) {
                    try {
                        Method m = c.getMethod(method.getName(), method.getParameterTypes());
                        if (!m.isAnnotationPresent(marker)) continue;
                        this.checkSingleArgument(method);
                        return true;
                    }
                    catch (NoSuchMethodException ignored) {
                    }
                }
                return false;
            }

            private void checkSingleArgument(Method method) {
                int paramCount = method.getParameterTypes().length;
                if (paramCount != 1) {
                    String msg = String.format("Method %s has @%s annotation, but requires %d arguments.  Event handler methods must require a single argument.", method, marker.getSimpleName(), paramCount);
                    throw new IllegalArgumentException(msg);
                }
            }
        };
    }

    public static Set<Class<?>> linearizeHierarchy(Class<?> concreteClass) {
        try {
            return (Set)HIERARCHIES.getUnchecked(concreteClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    static /* synthetic */ LoadingCache access$000(CacheLoader x0) {
        return Handlers.weakKeyCache(x0);
    }

    public static final class EventAndTargets {
        public final Object event;
        public final Iterable<Object> targets;

        public EventAndTargets(Object event, Iterable<Object> targets) {
            this.event = event;
            this.targets = targets;
        }
    }

    public static final class EventHandler
    implements Handler,
    Runnable {
        private final Logger logger;
        private final Queue<EventAndTargets> pending = Queues.newConcurrentLinkedQueue();
        private final Executor deliveryExecutor;
        private final EventDelivery delivery;
        private final boolean batchDelivery;
        @CheckForNull
        private Set<Object> strongTargets;
        @CheckForNull
        private Set<Object> weakTargets;

        protected EventHandler(Logger logger, EventDelivery delivery, boolean batchDelivery, Executor deliveryExecutor) {
            this.logger = logger;
            this.delivery = delivery;
            this.batchDelivery = batchDelivery;
            this.deliveryExecutor = deliveryExecutor;
        }

        public static EventHandler create(Logger logger, EventDelivery delivery, boolean batchDelivery, Executor deliveryExecutor) {
            return new EventHandler(logger, delivery, batchDelivery, deliveryExecutor);
        }

        @Override
        public void run() {
            EventAndTargets next = this.pending.poll();
            if (next == null) {
                return;
            }
            Object event = next.event;
            for (Object target : next.targets) {
                try {
                    this.delivery.deliverEvent(target, event);
                }
                catch (RuntimeException e) {
                    this.logger.log(Level.SEVERE, "Could not dispatch event", e);
                }
            }
        }

        @Override
        public synchronized boolean dispatch(Object event) {
            Collection<Object> targets = this.getTargets();
            if (targets == null || targets.isEmpty()) {
                return false;
            }
            if (this.batchDelivery) {
                this.deliverBatchMode(event, targets);
            } else {
                this.deliverSingleMode(event, targets);
            }
            return true;
        }

        private void deliverSingleMode(Object event, Collection<Object> targets) {
            for (Object target : targets) {
                this.pending.add(new EventAndTargets(event, Collections.singleton(target)));
                this.deliveryExecutor.execute(this);
            }
        }

        private void deliverBatchMode(Object event, Collection<Object> targets) {
            this.pending.add(new EventAndTargets(event, targets));
            this.deliveryExecutor.execute(this);
        }

        @CheckForNull
        private synchronized Collection<Object> getTargets() {
            Set<Object> s = this.strongTargets;
            Set<Object> w = this.weakTargets;
            if (s == null && w == null) {
                return null;
            }
            if (s == null) {
                ArrayList targets = Lists.newArrayList(w);
                if (targets.isEmpty()) {
                    this.weakTargets = null;
                    return null;
                }
                return targets;
            }
            if (w == null) {
                return Lists.newArrayList(s);
            }
            int count = s.size() + w.size();
            Collection<Object> snapshot = count < 2 ? Lists.newArrayListWithCapacity((int)1) : EventHandler.newStrongSet(count);
            snapshot.addAll(s);
            snapshot.addAll(w);
            return snapshot;
        }

        private static Set<Object> newStrongSet() {
            return Collections.newSetFromMap(Maps.newIdentityHashMap());
        }

        private static Set<Object> newStrongSet(int expectedMaxSize) {
            return Collections.newSetFromMap(new IdentityHashMap(expectedMaxSize));
        }

        private static Set<Object> newWeakSet() {
            return Collections.newSetFromMap(new MapMaker().concurrencyLevel(1).weakKeys().makeMap());
        }

        @Override
        public synchronized void register(Object target) {
            if (this.strongTargets == null) {
                this.strongTargets = EventHandler.newStrongSet();
            }
            this.strongTargets.add(target);
        }

        @Override
        public synchronized void registerWeak(Object target) {
            if (this.weakTargets == null) {
                this.weakTargets = EventHandler.newWeakSet();
            }
            this.weakTargets.add(target);
        }

        @Override
        public synchronized void unregister(Object target) {
            if (this.strongTargets != null) {
                this.strongTargets.remove(target);
                if (this.strongTargets.isEmpty()) {
                    this.strongTargets = null;
                }
            }
            if (this.weakTargets != null) {
                this.weakTargets.remove(target);
                if (this.weakTargets.isEmpty()) {
                    this.weakTargets = null;
                }
            }
        }
    }

    private static class SynchronizedDelivery
    implements EventDelivery {
        private static final LoadingCache<Object, Object> SYNCS_BY_TARGET = Handlers.access$000((CacheLoader)new CacheLoader<Object, Object>(){

            public Object load(Object key) throws Exception {
                return new Object();
            }
        });
        private final EventDelivery delivery;

        public SynchronizedDelivery(EventDelivery delivery) {
            this.delivery = delivery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deliverEvent(Object target, Object event) {
            Object object = SYNCS_BY_TARGET.getUnchecked(target);
            synchronized (object) {
                this.delivery.deliverEvent(target, event);
            }
        }
    }

    public static interface EventDelivery {
        public void deliverEvent(Object var1, Object var2);
    }
}

