/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.Block;
import ch.epfl.dedis.byzcoin.Config;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.SignerCounters;
import ch.epfl.dedis.byzcoin.StateChange;
import ch.epfl.dedis.byzcoin.StateChanges;
import ch.epfl.dedis.byzcoin.Subscription;
import ch.epfl.dedis.byzcoin.contracts.ChainConfigData;
import ch.epfl.dedis.byzcoin.contracts.ChainConfigInstance;
import ch.epfl.dedis.byzcoin.contracts.DarcInstance;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.ClientTransactionId;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityEd25519;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.network.Roster;
import ch.epfl.dedis.lib.network.ServerIdentity;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import ch.epfl.dedis.skipchain.SkipchainRPC;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByzCoinRPC {
    private Config config;
    private Roster roster;
    private Darc genesisDarc;
    private SkipBlock genesis;
    private SkipBlock latest;
    private SkipchainRPC skipchain;
    private Subscription subscription;
    public static final int currentVersion = 1;
    private static final Logger logger = LoggerFactory.getLogger(ByzCoinRPC.class);

    public ByzCoinRPC(Roster r, Darc d, Duration blockInterval) throws CothorityException {
        if (d.getExpression("invoke:" + ChainConfigInstance.ContractId + ".view_change") == null) {
            throw new CothorityCommunicationException("need a view change rule.");
        }
        ByzCoinProto.CreateGenesisBlock.Builder request = ByzCoinProto.CreateGenesisBlock.newBuilder();
        request.setVersion(1);
        request.setRoster(r.toProto());
        request.setGenesisdarc(d.toProto());
        request.setBlockinterval(blockInterval.toNanos());
        ByteString msg = r.sendMessage("ByzCoin/CreateGenesisBlock", request.build());
        try {
            ByzCoinProto.CreateGenesisBlockResponse reply = ByzCoinProto.CreateGenesisBlockResponse.parseFrom(msg);
            this.genesis = new SkipBlock(reply.getSkipblock());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
        this.latest = this.genesis;
        logger.info("Created new ByzCoin ledger with ID: {}", (Object)this.genesis.getId().toString());
        this.skipchain = new SkipchainRPC(r, this.genesis.getId());
        this.config = new Config(blockInterval);
        this.roster = r;
        this.genesisDarc = d;
        this.subscription = new Subscription(this);
    }

    protected ByzCoinRPC() {
    }

    protected ByzCoinRPC(ByzCoinRPC bc) {
        this.config = bc.config;
        this.roster = bc.roster;
        this.genesisDarc = bc.genesisDarc;
        this.genesis = bc.genesis;
        this.latest = bc.latest;
        this.skipchain = bc.skipchain;
        this.subscription = bc.subscription;
    }

    public ClientTransactionId sendTransaction(ClientTransaction t) throws CothorityException {
        return this.sendTransactionAndWait(t, 0);
    }

    public ClientTransactionId sendTransactionAndWait(ClientTransaction t, int wait) throws CothorityCommunicationException {
        ByzCoinProto.AddTxRequest.Builder request = ByzCoinProto.AddTxRequest.newBuilder();
        request.setVersion(1);
        request.setSkipchainid(ByteString.copyFrom((byte[])this.skipchain.getID().getId()));
        request.setTransaction(t.toProto());
        request.setInclusionwait(wait);
        ByteString msg = this.roster.sendMessage("ByzCoin/AddTxRequest", request.build());
        try {
            ByzCoinProto.AddTxResponse reply = ByzCoinProto.AddTxResponse.parseFrom(msg);
            logger.info("Successfully stored request - waiting for inclusion");
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
        return t.getId();
    }

    public Proof getProof(InstanceId id) throws CothorityCommunicationException, CothorityCryptoException {
        ByzCoinProto.GetProof.Builder request = ByzCoinProto.GetProof.newBuilder();
        request.setVersion(1);
        request.setId(this.skipchain.getID().toProto());
        request.setKey(id.toByteString());
        ByteString msg = this.roster.sendMessage("ByzCoin/GetProof", request.build());
        try {
            ByzCoinProto.GetProofResponse reply = ByzCoinProto.GetProofResponse.parseFrom(msg);
            Proof p = new Proof(reply.getProof(), this.skipchain.getID());
            logger.info("Successfully received and created proof");
            return p;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException("failed to get proof: " + e.getMessage());
        }
    }

    public SignerCounters getSignerCounters(List<String> signerIDs) throws CothorityCommunicationException {
        ByzCoinProto.GetSignerCounters.Builder b = ByzCoinProto.GetSignerCounters.newBuilder();
        b.addAllSignerids(signerIDs);
        b.setSkipchainid(this.skipchain.getID().toProto());
        ByteString msg = this.roster.sendMessage("ByzCoin/GetSignerCounters", b.build());
        try {
            ByzCoinProto.GetSignerCountersResponse reply = ByzCoinProto.GetSignerCountersResponse.parseFrom(msg);
            logger.info("successfully parsed signer counters");
            return new SignerCounters(reply);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public void update() throws CothorityException {
        List<SkipBlock> sbs = this.skipchain.getUpdateChain();
        if (sbs != null && sbs.size() > 0) {
            this.latest = sbs.get(sbs.size() - 1);
        }
    }

    public boolean checkLiveness() {
        for (ServerIdentity si : this.roster.getNodes()) {
            try {
                logger.info("Checking status of {}", (Object)si.getAddress());
                si.GetStatus();
            }
            catch (CothorityCommunicationException e) {
                logger.warn("Failing node {}: {}", (Object)si.getAddress(), (Object)e.toString());
                return false;
            }
        }
        return true;
    }

    public byte[] toBytes() {
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public Darc getGenesisDarc() {
        return this.genesisDarc;
    }

    public DarcInstance getGenesisDarcInstance() throws CothorityException {
        return DarcInstance.fromByzCoin(this, this.genesisDarc);
    }

    public SkipBlock getGenesisBlock() {
        return this.genesis;
    }

    public Roster getRoster() {
        return new Roster(this.roster.getNodes());
    }

    public Block getBlock(SkipblockId id) throws CothorityCommunicationException, CothorityCryptoException {
        SkipBlock sb = this.skipchain.getSkipblock(id);
        return new Block(sb);
    }

    public Block getLatestBlock() throws CothorityException {
        this.update();
        return new Block(this.latest);
    }

    public List<String> checkAuthorization(DarcId id, List<Identity> identities) throws CothorityCommunicationException {
        ByzCoinProto.CheckAuthorization.Builder request = ByzCoinProto.CheckAuthorization.newBuilder();
        request.setVersion(1);
        request.setByzcoinid(ByteString.copyFrom((byte[])this.skipchain.getID().getId()));
        request.setDarcid(ByteString.copyFrom((byte[])id.getId()));
        identities.forEach(identity -> request.addIdentities(identity.toProto()));
        ByteString msg = this.roster.sendMessage("ByzCoin/CheckAuthorization", request.build());
        try {
            ByzCoinProto.CheckAuthorizationResponse reply = ByzCoinProto.CheckAuthorizationResponse.parseFrom(msg);
            logger.info("Got request reply: {}", (Object)reply);
            return reply.getActionsList();
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public StateChange getInstanceVersion(InstanceId id, long version) throws CothorityCommunicationException {
        ByzCoinProto.GetInstanceVersion.Builder request = ByzCoinProto.GetInstanceVersion.newBuilder();
        request.setInstanceid(id.toByteString());
        request.setSkipchainid(this.genesis.getId().toProto());
        request.setVersion(version);
        ByteString msg = this.roster.sendMessage("ByzCoin/GetInstanceVersion", request.build());
        try {
            ByzCoinProto.GetInstanceVersionResponse reply = ByzCoinProto.GetInstanceVersionResponse.parseFrom(msg);
            return new StateChange(reply.getStatechange());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public StateChange getLastInstanceVersion(InstanceId id) throws CothorityCommunicationException {
        ByzCoinProto.GetLastInstanceVersion.Builder request = ByzCoinProto.GetLastInstanceVersion.newBuilder();
        request.setInstanceid(id.toByteString());
        request.setSkipchainid(this.genesis.getId().toProto());
        ByteString msg = this.roster.sendMessage("ByzCoin/GetLastInstanceVersion", request.build());
        try {
            ByzCoinProto.GetInstanceVersionResponse reply = ByzCoinProto.GetInstanceVersionResponse.parseFrom(msg);
            return new StateChange(reply.getStatechange());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public List<StateChange> getAllInstanceVersion(InstanceId id) throws CothorityCommunicationException {
        ByzCoinProto.GetAllInstanceVersion.Builder request = ByzCoinProto.GetAllInstanceVersion.newBuilder();
        request.setInstanceid(id.toByteString());
        request.setSkipchainid(this.genesis.getId().toProto());
        ByteString msg = this.roster.sendMessage("ByzCoin/GetAllInstanceVersion", request.build());
        try {
            ByzCoinProto.GetAllInstanceVersionResponse reply = ByzCoinProto.GetAllInstanceVersionResponse.parseFrom(msg);
            return reply.getStatechangesList().stream().map(sc -> new StateChange(sc.getStatechange())).collect(Collectors.toList());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public boolean checkStateChangeValidity(StateChange sc) throws CothorityCommunicationException {
        ByzCoinProto.CheckStateChangeValidity.Builder request = ByzCoinProto.CheckStateChangeValidity.newBuilder();
        request.setInstanceid(sc.getInstanceId().toByteString());
        request.setSkipchainid(this.genesis.getId().toProto());
        request.setVersion(sc.getVersion());
        ByteString msg = this.roster.sendMessage("ByzCoin/CheckStateChangeValidity", request.build());
        try {
            ByzCoinProto.CheckStateChangeValidityResponse reply = ByzCoinProto.CheckStateChangeValidityResponse.parseFrom(msg);
            StateChanges scs = new StateChanges(reply.getStatechangesList());
            SkipBlock skipblock = this.skipchain.getSkipblock(new SkipblockId(reply.getBlockid()));
            ByzCoinProto.DataHeader dh = ByzCoinProto.DataHeader.parseFrom(skipblock.getData());
            return scs.getHash().equals((Object)dh.getStatechangeshash());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SkipchainRPC getSkipchain() {
        logger.warn("usually you should not need this - please tell us why you do anyway.");
        return this.skipchain;
    }

    public void subscribeSkipBlock(Subscription.SkipBlockReceiver sbr) throws CothorityCommunicationException {
        this.subscription.subscribeSkipBlock(sbr);
    }

    public Stream<SkipBlock> subscribeSkipBlock() throws CothorityCommunicationException {
        LinkedBlockingQueue<SkipBlock> queue = new LinkedBlockingQueue<SkipBlock>();
        ServerIdentity.StreamingConn conn = this.streamTransactions(queue);
        Stream<SkipBlock> stream = Stream.generate(() -> {
            try {
                return (SkipBlock)queue.take();
            }
            catch (InterruptedException e) {
                return null;
            }
        });
        return ((Stream)stream.onClose(conn::close)).filter(Objects::nonNull);
    }

    public void unsubscribeBlock(Subscription.SkipBlockReceiver sbr) {
        this.subscription.unsubscribeSkipBlock(sbr);
    }

    public void setRoster(Roster newRoster, List<Signer> admins, List<Long> adminCtrs, int wait) throws CothorityException {
        ChainConfigInstance cci = ChainConfigInstance.fromByzcoin(this);
        ChainConfigData ccd = cci.getChainConfig();
        ccd.setRoster(newRoster);
        cci.evolveConfigAndWait(ccd, admins, adminCtrs, wait);
        this.roster = new Roster(newRoster.getNodes());
    }

    public void setBlockInterval(Duration newInterval, List<Signer> admins, List<Long> adminCtrs, int wait) throws CothorityException {
        ChainConfigInstance cci = ChainConfigInstance.fromByzcoin(this);
        ChainConfigData ccd = cci.getChainConfig();
        ccd.setInterval(newInterval);
        cci.evolveConfigAndWait(ccd, admins, adminCtrs, wait);
    }

    public void setMaxBlockSize(int newMaxSize, List<Signer> admins, List<Long> adminCtrs, int wait) throws CothorityException {
        ChainConfigInstance cci = ChainConfigInstance.fromByzcoin(this);
        ChainConfigData ccd = cci.getChainConfig();
        ccd.setMaxBlockSize(newMaxSize);
        cci.evolveConfigAndWait(ccd, admins, adminCtrs, wait);
    }

    public static ByzCoinRPC fromByzCoin(Roster roster, SkipblockId skipchainId) throws CothorityException {
        Proof proof = ByzCoinRPC.getProof(roster, skipchainId, InstanceId.zero());
        if (!proof.contractIsType("config")) {
            throw new CothorityNotFoundException("couldn't verify proof for genesisConfiguration");
        }
        if (!proof.exists(InstanceId.zero().getId())) {
            throw new CothorityNotFoundException("config instance does not exist");
        }
        ByzCoinRPC bc = new ByzCoinRPC();
        bc.config = new Config(proof.getValue());
        Proof proof2 = ByzCoinRPC.getProof(roster, skipchainId, new InstanceId(proof.getDarcID().getId()));
        if (!proof2.contractIsType(DarcInstance.ContractId)) {
            throw new CothorityNotFoundException("couldn't verify proof for genesisConfiguration");
        }
        if (!proof2.exists(proof.getDarcID().getId())) {
            throw new CothorityNotFoundException("darc instance does not exist");
        }
        try {
            bc.genesisDarc = new Darc(proof2.getValue());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException("couldn't get genesis darc: " + e.getMessage());
        }
        bc.skipchain = new SkipchainRPC(roster, skipchainId);
        bc.roster = roster;
        bc.genesis = bc.skipchain.getSkipblock(skipchainId);
        bc.subscription = new Subscription(bc);
        List<SkipBlock> sbs = bc.skipchain.getUpdateChain();
        bc.latest = sbs.get(sbs.size() - 1);
        return bc;
    }

    public static Darc makeGenesisDarc(Signer admin, Roster roster) throws CothorityCryptoException {
        Darc d = new Darc(Arrays.asList(admin.getIdentity()), Arrays.asList(admin.getIdentity()), "Genesis darc".getBytes());
        roster.getNodes().forEach(node -> {
            try {
                d.addIdentity("invoke:" + ChainConfigInstance.ContractId + ".view_change", new IdentityEd25519((Ed25519Point)node.getPublic()), " | ");
            }
            catch (CothorityCryptoException e) {
                logger.warn("didn't find Ed25519 point");
            }
        });
        d.addIdentity("spawn:darc", admin.getIdentity(), " | ");
        d.addIdentity("invoke:" + ChainConfigInstance.ContractId + ".update_config", admin.getIdentity(), " | ");
        return d;
    }

    private static Proof getProof(Roster roster, SkipblockId skipchainId, InstanceId key) throws CothorityCommunicationException, CothorityCryptoException {
        ByzCoinProto.GetProof.Builder configBuilder = ByzCoinProto.GetProof.newBuilder();
        configBuilder.setVersion(1);
        configBuilder.setId(skipchainId.toProto());
        configBuilder.setKey(key.toByteString());
        ByteString msg = roster.sendMessage("ByzCoin/GetProof", configBuilder.build());
        try {
            ByzCoinProto.GetProofResponse reply = ByzCoinProto.GetProofResponse.parseFrom(msg);
            return new Proof(reply.getProof(), skipchainId);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    ServerIdentity.StreamingConn streamTransactions(final Subscription.SkipBlockReceiver receiver) throws CothorityCommunicationException {
        ByzCoinProto.StreamingRequest.Builder req = ByzCoinProto.StreamingRequest.newBuilder();
        req.setId(this.skipchain.getID().toProto());
        ServerIdentity.StreamHandler h = new ServerIdentity.StreamHandler(){

            @Override
            public void receive(ByteBuffer message) {
                try {
                    SkipchainProto.SkipBlock block = ByzCoinProto.StreamingResponse.parseFrom(message).getBlock();
                    receiver.receive(new SkipBlock(block));
                }
                catch (InvalidProtocolBufferException e) {
                    receiver.error(e.getMessage());
                }
            }

            @Override
            public void error(String s) {
                receiver.error(s);
            }
        };
        return this.roster.makeStreamingConn("ByzCoin/StreamingRequest", req.build(), h);
    }

    private ServerIdentity.StreamingConn streamTransactions(final BlockingQueue<SkipBlock> queue) throws CothorityCommunicationException {
        ByzCoinProto.StreamingRequest.Builder req = ByzCoinProto.StreamingRequest.newBuilder();
        req.setId(this.skipchain.getID().toProto());
        ServerIdentity.StreamHandler h = new ServerIdentity.StreamHandler(){

            @Override
            public void receive(ByteBuffer message) {
                try {
                    SkipchainProto.SkipBlock block = ByzCoinProto.StreamingResponse.parseFrom(message).getBlock();
                    queue.add(new SkipBlock(block));
                }
                catch (InvalidProtocolBufferException e) {
                    logger.error(e.getMessage());
                }
            }

            @Override
            public void error(String s) {
                logger.error(s);
            }
        };
        return this.roster.makeStreamingConn("ByzCoin/StreamingRequest", req.build(), h);
    }
}

