/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class Config {
    private Duration blockInterval;
    private int maxBlockSize;

    public Config(Duration blockInterval) {
        this.blockInterval = blockInterval;
    }

    public Config(ByzCoinProto.ChainConfig config) {
        this.blockInterval = Duration.of(config.getBlockinterval(), ChronoUnit.NANOS);
    }

    public Config(byte[] buf) throws CothorityCommunicationException {
        try {
            ByzCoinProto.ChainConfig config = ByzCoinProto.ChainConfig.parseFrom(buf);
            this.blockInterval = Duration.of(config.getBlockinterval(), ChronoUnit.NANOS);
            if (!config.hasMaxblocksize()) {
                throw new RuntimeException("no max block size");
            }
            this.maxBlockSize = config.getMaxblocksize();
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public Duration getBlockInterval() {
        return this.blockInterval;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public ByzCoinProto.ChainConfig toProto() {
        ByzCoinProto.ChainConfig.Builder b = ByzCoinProto.ChainConfig.newBuilder();
        b.setBlockinterval(this.blockInterval.get(ChronoUnit.NANOS));
        b.setMaxblocksize(this.maxBlockSize);
        return b.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.blockInterval.equals(config.blockInterval) && this.maxBlockSize == config.maxBlockSize;
    }
}

