/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.StateChangeBody;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Bn256G2Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.network.ServerIdentity;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import ch.epfl.dedis.lib.proto.NetworkProto;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import ch.epfl.dedis.lib.proto.TrieProto;
import ch.epfl.dedis.skipchain.ForwardLink;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Proof {
    private final TrieProto.Proof proof;
    private final List<SkipchainProto.ForwardLink> links;
    private final SkipBlock latest;
    private final StateChangeBody finalStateChangeBody;

    public Proof(ByzCoinProto.Proof p, SkipblockId scID) throws CothorityCryptoException {
        this.proof = p.getInclusionproof();
        this.latest = new SkipBlock(p.getLatest());
        this.links = p.getLinksList();
        this.verify(scID);
        if (this.matches()) {
            try {
                this.finalStateChangeBody = new StateChangeBody(ByzCoinProto.StateChangeBody.parseFrom(this.proof.getLeaf().getValue()));
            }
            catch (InvalidProtocolBufferException e) {
                throw new CothorityCryptoException("failed to decode state change body: " + e.getMessage());
            }
        } else {
            this.finalStateChangeBody = null;
        }
    }

    public Instance getInstance() throws CothorityNotFoundException {
        return Instance.fromProof(this);
    }

    public ByzCoinProto.Proof toProto() {
        ByzCoinProto.Proof.Builder b = ByzCoinProto.Proof.newBuilder();
        b.setInclusionproof(this.proof);
        b.setLatest(this.latest.getProto());
        for (SkipchainProto.ForwardLink link : this.links) {
            b.addLinks(link);
        }
        return b.build();
    }

    public SkipBlock getLatest() {
        return this.latest;
    }

    private void verify(SkipblockId scID) throws CothorityCryptoException {
        ByzCoinProto.DataHeader header;
        try {
            header = ByzCoinProto.DataHeader.parseFrom(this.latest.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        if (!Arrays.equals(this.getRoot(), header.getTrieroot().toByteArray())) {
            throw new CothorityCryptoException("root of trie is not in skipblock");
        }
        SkipblockId sbID = null;
        List<Point> publics = null;
        for (int i = 0; i < this.links.size(); ++i) {
            if (i == 0) {
                sbID = scID;
                publics = Proof.getPoints(this.links.get(i).getNewRoster().getListList());
                continue;
            }
            ForwardLink l = new ForwardLink(this.links.get(i));
            if (!l.verify(publics)) {
                throw new CothorityCryptoException("stored skipblock is not properly evolved from genesis block");
            }
            if (!Arrays.equals(l.getFrom().getId(), sbID.getId())) {
                throw new CothorityCryptoException("stored skipblock is not properly evolved from genesis block");
            }
            sbID = l.getTo();
            try {
                if (l.getNewRoster() == null) continue;
                publics = Proof.getPoints(this.links.get(i).getNewRoster().getListList());
                continue;
            }
            catch (URISyntaxException e) {
                throw new CothorityCryptoException(e.getMessage());
            }
        }
    }

    public byte[] getRoot() {
        if (this.proof.getInteriorsCount() == 0) {
            return null;
        }
        return Proof.hashInterior(this.proof.getInteriors(0));
    }

    public byte[] getKey() {
        return this.proof.getLeaf().getKey().toByteArray();
    }

    public StateChangeBody getValues() {
        return this.finalStateChangeBody;
    }

    public byte[] getValue() {
        return this.getValues().getValue();
    }

    public String getContractID() {
        return new String(this.getValues().getContractID());
    }

    public DarcId getDarcID() {
        return this.getValues().getDarcId();
    }

    public boolean contractIsType(String expectedType) {
        return this.getContractID().equals(expectedType);
    }

    public boolean matches() {
        if (!this.proof.hasLeaf()) {
            return false;
        }
        if (this.proof.getLeaf().getKey().isEmpty()) {
            return false;
        }
        try {
            return this.exists(this.proof.getLeaf().getKey().toByteArray());
        }
        catch (CothorityCryptoException e) {
            return false;
        }
    }

    public boolean exists(byte[] key) throws CothorityCryptoException {
        int i;
        if (key == null) {
            throw new CothorityCryptoException("key is nil");
        }
        if (this.proof.getInteriorsCount() == 0) {
            throw new CothorityCryptoException("no interior nodes");
        }
        Boolean[] bits = Proof.binSlice(key);
        byte[] expectedHash = Proof.hashInterior(this.proof.getInteriors(0));
        for (i = 0; i < this.proof.getInteriorsCount(); ++i) {
            if (!Arrays.equals(expectedHash, Proof.hashInterior(this.proof.getInteriors(i)))) {
                throw new CothorityCryptoException("invalid interior node");
            }
            expectedHash = bits[i] != false ? this.proof.getInteriors(i).getLeft().toByteArray() : this.proof.getInteriors(i).getRight().toByteArray();
        }
        if (Arrays.equals(expectedHash, Proof.hashLeaf(this.proof.getLeaf(), this.proof.getNonce().toByteArray()))) {
            if (!Arrays.equals((Object[])Arrays.copyOf(bits, i), (Object[])this.proof.getLeaf().getPrefixList().toArray(new Boolean[0]))) {
                throw new CothorityCryptoException("invalid prefix in leaf node");
            }
            return Arrays.equals(this.proof.getLeaf().getKey().toByteArray(), key);
        }
        if (Arrays.equals(expectedHash, Proof.hashEmpty(this.proof.getEmpty(), this.proof.getNonce().toByteArray()))) {
            if (!Arrays.equals((Object[])Arrays.copyOf(bits, i), (Object[])this.proof.getEmpty().getPrefixList().toArray(new Boolean[0]))) {
                throw new CothorityCryptoException("invalid prefix in empty node");
            }
            return false;
        }
        throw new CothorityCryptoException("no corresponding leaf/empty node with respect to the interior nodes");
    }

    private static Boolean[] binSlice(byte[] buf) {
        byte[] hashKey;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(buf);
            hashKey = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Boolean[] bits = new Boolean[hashKey.length * 8];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = (hashKey[i / 8] << i % 8 & 0x80) > 0;
        }
        return bits;
    }

    private static byte[] toByteSlice(List<Boolean> bits) {
        byte[] buf = new byte[(bits.size() + 7) / 8];
        for (int i = 0; i < bits.size(); ++i) {
            if (!bits.get(i).booleanValue()) continue;
            int n = i / 8;
            buf[n] = (byte)(buf[n] | 128 >> i % 8);
        }
        return buf;
    }

    private static byte[] hashInterior(TrieProto.InteriorNode interior) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(interior.getLeft().toByteArray());
            digest.update(interior.getRight().toByteArray());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] hashLeaf(TrieProto.LeafNode leaf, byte[] nonce) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(new byte[]{3});
            digest.update(nonce);
            digest.update(Proof.toByteSlice(leaf.getPrefixList()));
            byte[] lBuf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(leaf.getPrefixCount()).array();
            digest.update(lBuf);
            digest.update(leaf.getKey().toByteArray());
            digest.update(leaf.getValue().toByteArray());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] hashEmpty(TrieProto.EmptyNode empty, byte[] nonce) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(new byte[]{2});
            digest.update(nonce);
            digest.update(Proof.toByteSlice(empty.getPrefixList()));
            byte[] lBuf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(empty.getPrefixCount()).array();
            digest.update(lBuf);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Point> getPoints(List<NetworkProto.ServerIdentity> protos) throws CothorityCryptoException {
        ArrayList<ServerIdentity> sids = new ArrayList<ServerIdentity>();
        for (NetworkProto.ServerIdentity sid2 : protos) {
            try {
                sids.add(new ServerIdentity(sid2));
            }
            catch (URISyntaxException e) {
                throw new CothorityCryptoException(e.getMessage());
            }
        }
        return sids.stream().map(sid -> (Bn256G2Point)sid.getServicePublic("Skipchain")).collect(Collectors.toList());
    }
}

