/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import com.google.protobuf.ByteString;
import java.io.UnsupportedEncodingException;

public class StateChange {
    private StateAction stateAction;
    private InstanceId instanceId;
    private String contractId;
    private DarcId darcId;
    private ByteString value;
    private long version;

    public StateChange(ByzCoinProto.StateChange sc) {
        this.instanceId = new InstanceId(sc.getInstanceid());
        this.value = sc.getValue();
        this.version = sc.getVersion();
        try {
            this.contractId = sc.getContractid().toString("utf8");
        }
        catch (UnsupportedEncodingException e) {
            this.contractId = "";
        }
        if (!sc.getDarcid().isEmpty()) {
            this.darcId = new DarcId(sc.getDarcid());
        }
        this.stateAction = StateAction.fromInteger(sc.getStateaction());
    }

    public StateAction getStateAction() {
        return this.stateAction;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String getContractId() {
        return this.contractId;
    }

    public DarcId getDarcId() {
        return this.darcId;
    }

    public ByteString getValue() {
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public static enum StateAction {
        Create,
        Update,
        Remove,
        Unknown;


        public static StateAction fromInteger(int i) {
            switch (i) {
                case 1: {
                    return Create;
                }
                case 2: {
                    return Update;
                }
                case 3: {
                    return Remove;
                }
            }
            return Unknown;
        }
    }
}

