/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;

public class StateChangeBody {
    private int stateAction;
    private byte[] contractID;
    private byte[] value;
    private long version;
    private DarcId darcId;

    public StateChangeBody(ByzCoinProto.StateChangeBody proto) throws CothorityCryptoException {
        this.stateAction = proto.getStateaction();
        this.contractID = proto.getContractid().toByteArray();
        this.value = proto.getValue().toByteArray();
        this.version = proto.getVersion();
        if (proto.getDarcid().toByteArray().length != 32) {
            throw new CothorityCryptoException("darc ID is empty");
        }
        this.darcId = new DarcId(proto.getDarcid());
    }

    public int getStateAction() {
        return this.stateAction;
    }

    public byte[] getContractID() {
        return this.contractID;
    }

    public byte[] getValue() {
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public DarcId getDarcId() {
        return this.darcId;
    }
}

