/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.contracts;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.contracts.ChainConfigInstance;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.exception.CothorityPermissionException;
import ch.epfl.dedis.lib.network.Roster;
import ch.epfl.dedis.lib.network.ServerIdentity;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainConfigData {
    public static final int blocksizeMin = 16000;
    public static final int blocksizeMax = 8000000;
    private ByzCoinProto.ChainConfig.Builder config;
    private static final Logger logger = LoggerFactory.getLogger(ChainConfigData.class);

    public ChainConfigData(Instance inst) throws CothorityNotFoundException {
        if (!inst.getContractId().equals(ChainConfigInstance.ContractId)) {
            throw new CothorityNotFoundException("wrong contract type in instance");
        }
        try {
            this.config = ByzCoinProto.ChainConfig.parseFrom(inst.getData()).toBuilder();
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityNotFoundException("couldn't decode the data: " + e.getMessage());
        }
    }

    public ChainConfigData(ByzCoinProto.ChainConfig config) {
        this.config = config.toBuilder();
    }

    public ChainConfigData(ChainConfigData config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            config.toProto().writeTo(out);
            out.close();
            this.config = ByzCoinProto.ChainConfig.parseFrom(out.toByteArray()).toBuilder();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write to output stream: " + e.getMessage());
        }
    }

    public void setRoster(Roster newRoster) throws CothorityCommunicationException {
        HashSet<ServerIdentity> oldSIs;
        HashSet<ServerIdentity> newSIs = new HashSet<ServerIdentity>(newRoster.getNodes());
        try {
            oldSIs = new HashSet<ServerIdentity>(new Roster(this.config.getRoster()).getNodes());
        }
        catch (URISyntaxException e) {
            throw new CothorityCommunicationException("Error in stored roster:" + e.getMessage());
        }
        if (newSIs.containsAll(oldSIs) && oldSIs.containsAll(newSIs)) {
            return;
        }
        this.config.setRoster(newRoster.toProto());
    }

    private void checkNewRoster(Roster newRoster) throws CothorityException {
        HashSet<ServerIdentity> oldSIs;
        HashSet<ServerIdentity> newSIs = new HashSet<ServerIdentity>(newRoster.getNodes());
        try {
            oldSIs = new HashSet<ServerIdentity>(new Roster(this.config.getRoster()).getNodes());
        }
        catch (URISyntaxException e) {
            throw new CothorityCommunicationException("Error in stored roster:" + e.getMessage());
        }
        if (Math.abs(newSIs.size() - oldSIs.size()) > 1) {
            throw new CothorityPermissionException("Not allowed to change size of roster by more than one");
        }
        if (newSIs.size() < 4) {
            throw new CothorityPermissionException("Not allowed to have less than 4 nodes");
        }
        if (newSIs.size() % 3 != 1) {
            logger.warn("this is a non-optimal size of the roster. It should be 3n+1.");
        }
        if (!newSIs.containsAll(oldSIs) && !oldSIs.containsAll(newSIs)) {
            newSIs.addAll(oldSIs);
            logger.info("SIs are: {}", newSIs);
            throw new CothorityPermissionException("More than one node difference");
        }
        this.config.setRoster(newRoster.toProto());
    }

    public void setInterval(Duration newInterval) throws CothorityPermissionException {
        if (newInterval.toMillis() < 5000L) {
            throw new CothorityPermissionException("The interval should never be smaller than 5 seconds");
        }
        logger.info("Setting up new interval of {}", (Object)newInterval);
        this.config.setBlockinterval(newInterval.toNanos());
    }

    public void setMaxBlockSize(int newSize) throws CothorityPermissionException {
        if (newSize < 16000) {
            throw new CothorityPermissionException("The maximum block size must be bigger or equal to 16000");
        }
        if (newSize > 8000000) {
            throw new CothorityPermissionException("The maximum block size must be smaller than 8*10^6");
        }
        this.config.setMaxblocksize(newSize);
    }

    public ByzCoinProto.ChainConfig toProto() {
        return this.config.build();
    }
}

