/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.contracts;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.ClientTransactionId;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarcInstance {
    public static String ContractId = "darc";
    private Instance instance;
    private Darc darc;
    private ByzCoinRPC bc;
    private static final Logger logger = LoggerFactory.getLogger(DarcInstance.class);

    public DarcInstance(ByzCoinRPC bc, DarcId spawnerDarcId, Signer spawnerSigner, Long signerCtr, Darc newDarc) throws CothorityException {
        DarcInstance spawner = DarcInstance.fromByzCoin(bc, spawnerDarcId);
        DarcInstance newDarcInst = spawner.spawnDarcAndWait(newDarc, spawnerSigner, signerCtr, 10);
        this.bc = bc;
        this.darc = newDarc;
        this.instance = newDarcInst.getInstance();
    }

    private DarcInstance(ByzCoinRPC bc, Instance inst) throws CothorityException {
        this.bc = bc;
        if (!inst.getContractId().equals(ContractId)) {
            logger.error("wrong contract: {}", (Object)this.instance.getContractId());
            throw new CothorityNotFoundException("this is not a darc contract");
        }
        this.instance = inst;
        try {
            this.darc = new Darc(this.instance.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public void update() throws CothorityException {
        this.instance = Instance.fromByzcoin(this.bc, this.instance.getId());
        try {
            this.darc = new Darc(this.instance.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public Instruction evolveDarcInstruction(Darc newDarc, Long signerCtr) {
        newDarc.setVersion(this.getDarc().getVersion() + 1L);
        newDarc.setPrevId(this.darc);
        newDarc.setBaseId(this.darc.getBaseId());
        Invoke inv = new Invoke(ContractId, "evolve", ContractId, newDarc.toProto().toByteArray());
        byte[] d = newDarc.getBaseId().getId();
        return new Instruction(new InstanceId(d), Collections.singletonList(signerCtr), inv);
    }

    public void evolveDarc(Darc newDarc, Signer owner, Long ownerCtr) throws CothorityException {
        this.evolveDarcAndWait(newDarc, owner, ownerCtr, 0);
    }

    public ClientTransactionId evolveDarcAndWait(Darc newDarc, Signer owner, Long ownerCtr, int wait) throws CothorityException {
        Instruction inst = this.evolveDarcInstruction(newDarc, ownerCtr);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        ct.signWith(Collections.singletonList(owner));
        return this.bc.sendTransactionAndWait(ct, wait);
    }

    public Instruction spawnInstanceInstruction(String contractID, Long signerCtr, List<Argument> args) {
        Spawn sp = new Spawn(contractID, args);
        return new Instruction(new InstanceId(this.darc.getBaseId().getId()), Collections.singletonList(signerCtr), sp);
    }

    public ClientTransactionId spawnInstance(String contractID, Signer s, Long signerCtr, List<Argument> args) throws CothorityException {
        Instruction inst = this.spawnInstanceInstruction(contractID, signerCtr, args);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        ct.signWith(Collections.singletonList(s));
        return this.bc.sendTransaction(ct);
    }

    public Proof spawnInstanceAndWait(String contractID, Signer s, Long signerCtr, List<Argument> args, int wait) throws CothorityException {
        Proof p;
        Instruction inst = this.spawnInstanceInstruction(contractID, signerCtr, args);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        ct.signWith(Collections.singletonList(s));
        this.bc.sendTransactionAndWait(ct, wait);
        InstanceId iid = inst.deriveId("");
        if (contractID.equals(ContractId)) {
            try {
                Darc d = new Darc(args.get(0).getValue());
                iid = new InstanceId(d.getBaseId().getId());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CothorityCommunicationException("this is not a correct darc-spawn");
            }
        }
        if (!(p = this.bc.getProof(iid)).exists(iid.getId())) {
            throw new CothorityCryptoException("instance is not in proof");
        }
        return p;
    }

    public DarcInstance spawnDarcAndWait(Darc d, Signer s, Long signerCounter, int wait) throws CothorityException {
        ArrayList<Argument> args = new ArrayList<Argument>();
        args.add(new Argument("darc", d.toProto().toByteArray()));
        if (wait > 0) {
            Proof p = this.spawnInstanceAndWait(ContractId, s, signerCounter, args, wait);
            return new DarcInstance(this.bc, p.getInstance());
        }
        this.spawnInstance(ContractId, s, signerCounter, args);
        return null;
    }

    public DarcId getId() {
        return this.darc.getId();
    }

    public Darc getDarc() {
        return this.darc;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static DarcInstance fromByzCoin(ByzCoinRPC bc, InstanceId id) throws CothorityException {
        return new DarcInstance(bc, Instance.fromByzcoin(bc, id));
    }

    public static DarcInstance fromByzCoin(ByzCoinRPC bc, DarcId baseId) throws CothorityException {
        return DarcInstance.fromByzCoin(bc, new InstanceId(baseId.getId()));
    }

    public static DarcInstance fromByzCoin(ByzCoinRPC bc, Darc d) throws CothorityException {
        return DarcInstance.fromByzCoin(bc, d.getBaseId());
    }
}

