/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.transaction;

import ch.epfl.dedis.byzcoin.transaction.ClientTransactionId;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class ClientTransaction {
    private List<Instruction> instructions;

    public ClientTransaction(List<Instruction> instructions) {
        this.instructions = instructions;
    }

    public ClientTransaction(ByzCoinProto.ClientTransaction proto) throws CothorityCryptoException {
        this.instructions = new ArrayList<Instruction>();
        for (ByzCoinProto.Instruction i : proto.getInstructionsList()) {
            this.instructions.add(new Instruction(i));
        }
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public ByzCoinProto.ClientTransaction toProto() {
        ByzCoinProto.ClientTransaction.Builder b = ByzCoinProto.ClientTransaction.newBuilder();
        for (Instruction instr : this.instructions) {
            b.addInstructions(instr.toProto());
        }
        return b.build();
    }

    public void signWith(List<Signer> signers) throws CothorityCryptoException {
        byte[] h = this.hashInstructions();
        for (Instruction instr : this.instructions) {
            instr.signWith(h, signers);
        }
    }

    public ClientTransactionId getId() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (Instruction instr : this.instructions) {
                digest.update(instr.hash());
            }
            return new ClientTransactionId(digest.digest());
        }
        catch (CothorityCryptoException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] hashInstructions() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            for (Instruction instr : this.instructions) {
                digest.update(instr.hash());
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

