/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.transaction;

import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Invoke {
    private String contractID;
    private String command;
    private List<Argument> arguments;

    public Invoke(String cID, String command, List<Argument> arguments) {
        this.contractID = cID;
        this.command = command;
        this.arguments = arguments;
    }

    public Invoke(String cID, String command, String argName, byte[] value) {
        this(cID, command, Arrays.asList(new Argument(argName, value)));
    }

    public Invoke(ByzCoinProto.Invoke proto) {
        this.contractID = proto.getContractid();
        this.command = proto.getCommand();
        this.arguments = new ArrayList<Argument>();
        for (ByzCoinProto.Argument a : proto.getArgsList()) {
            this.arguments.add(new Argument(a));
        }
    }

    public String getContractId() {
        return this.contractID;
    }

    public String getCommand() {
        return this.command;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public ByzCoinProto.Invoke toProto() {
        ByzCoinProto.Invoke.Builder b = ByzCoinProto.Invoke.newBuilder();
        b.setContractid(this.contractID);
        b.setCommand(this.command);
        for (Argument a : this.arguments) {
            b.addArgs(a.toProto());
        }
        return b.build();
    }
}

