/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.calypso.LTSId;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.PointFactory;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.Calypso;

public class CreateLTSReply {
    private SkipblockId byzcoinId;
    private InstanceId instanceId;
    private Point X;

    public CreateLTSReply(Calypso.CreateLTSReply reply) {
        this.byzcoinId = new SkipblockId(reply.getInstanceid());
        this.instanceId = new InstanceId(reply.getInstanceid());
        this.X = PointFactory.getInstance().fromProto(reply.getX());
    }

    public SkipblockId getByzcoinId() {
        return this.byzcoinId;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public Point getX() {
        return this.X;
    }

    public LTSId getLTSID() {
        try {
            return new LTSId(this.instanceId.getId());
        }
        catch (CothorityCryptoException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

