/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.PointFactory;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.Calypso;

public class DecryptKeyReply {
    private Point C;
    private Point XhatEnc;
    private Point X;

    public DecryptKeyReply(Calypso.DecryptKeyReply proto) {
        this.C = PointFactory.getInstance().fromProto(proto.getC());
        this.XhatEnc = PointFactory.getInstance().fromProto(proto.getXhatenc());
        this.X = PointFactory.getInstance().fromProto(proto.getX());
    }

    public byte[] extractKeyMaterial(Scalar reader) throws CothorityCryptoException {
        Scalar xc = reader.reduce();
        Scalar xcInv = xc.negate();
        Point XhatDec = this.X.mul(xcInv);
        Point Xhat = this.XhatEnc.add(XhatDec);
        Point XhatInv = Xhat.negate();
        Point keyPointHat = this.C.add(XhatInv);
        return keyPointHat.data();
    }
}

