/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    public static final String ALGO = "AES/GCM/NoPadding";
    public static final String ALGO_KEY = "AES";
    public static final int KEY_LEN = 16;
    public static final int IV_LEN = 12;
    public static final int GCM_TLEN = 128;
    public static final int KEYMATERIAL_LEN = 28;

    public static byte[] encryptData(byte[] data, byte[] keyMaterial) throws CothorityCryptoException {
        KeyIv key = new KeyIv(keyMaterial);
        try {
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(1, (Key)key.keySpec, key.gcmSpec);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public static byte[] decryptData(byte[] dataEnc, byte[] keyMaterial) throws CothorityCryptoException {
        KeyIv key = new KeyIv(keyMaterial);
        try {
            Cipher cipher = Cipher.getInstance(ALGO);
            cipher.init(2, (Key)key.keySpec, key.gcmSpec);
            return cipher.doFinal(dataEnc);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public static class KeyIv {
        final byte[] symmetricKey;
        final byte[] iv;
        final GCMParameterSpec gcmSpec;
        final SecretKeySpec keySpec;

        public KeyIv(byte[] keyMaterial) throws CothorityCryptoException {
            if (keyMaterial.length != 28) {
                throw new CothorityCryptoException("keyMaterial must be 28 bytes");
            }
            this.iv = new byte[12];
            System.arraycopy(keyMaterial, 0, this.iv, 0, 12);
            this.gcmSpec = new GCMParameterSpec(128, this.iv);
            this.symmetricKey = new byte[16];
            this.keySpec = new SecretKeySpec(this.symmetricKey, Encryption.ALGO_KEY);
        }

        public KeyIv() {
            this.symmetricKey = new byte[16];
            this.iv = new byte[12];
            new SecureRandom().nextBytes(this.symmetricKey);
            new SecureRandom().nextBytes(this.iv);
            this.gcmSpec = new GCMParameterSpec(128, this.iv);
            this.keySpec = new SecretKeySpec(this.symmetricKey, Encryption.ALGO_KEY);
        }

        public byte[] getKeyMaterial() {
            byte[] keyMaterial = new byte[28];
            System.arraycopy(this.iv, 0, keyMaterial, 0, 12);
            System.arraycopy(this.symmetricKey, 0, keyMaterial, 12, 16);
            return keyMaterial;
        }
    }
}

