/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.calypso.ReadInstance;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.PointFactory;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.Calypso;
import com.google.protobuf.InvalidProtocolBufferException;

public class ReadData {
    private Calypso.Read read;

    public ReadData(InstanceId writeId, Point readerPk) {
        Calypso.Read.Builder b = Calypso.Read.newBuilder();
        b.setWrite(writeId.toByteString());
        b.setXc(readerPk.toProto());
        this.read = b.build();
    }

    public ReadData(Instance inst) throws CothorityNotFoundException {
        if (!inst.getContractId().equals(ReadInstance.ContractId)) {
            throw new CothorityNotFoundException("wrong contract type in instance");
        }
        try {
            this.read = Calypso.Read.parseFrom(inst.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityNotFoundException("couldn't decode the data: " + e.getMessage());
        }
    }

    public Point getXc() {
        return PointFactory.getInstance().fromProto(this.read.getXc());
    }

    public InstanceId getWriteId() {
        return new InstanceId(this.read.getWrite());
    }

    public Calypso.Read toProto() {
        return this.read;
    }

    public static ReadData fromProto(byte[] buf) throws InvalidProtocolBufferException {
        Calypso.Read rd = Calypso.Read.parseFrom(buf);
        Point p = PointFactory.getInstance().fromProto(rd.getXc());
        return new ReadData(new InstanceId(rd.getWrite()), p);
    }
}

