/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib;

import ch.epfl.dedis.lib.HashId;
import ch.epfl.dedis.lib.Hex;
import com.google.protobuf.ByteString;
import java.util.Arrays;

public class Sha256id
implements HashId {
    private final byte[] id;
    public static final int length = 32;

    public Sha256id(ByteString bs) {
        this(bs.toByteArray());
    }

    public Sha256id(byte[] id) {
        if (id.length != 32) {
            throw new RuntimeException("need 32 bytes for sha256-hash, only got " + id.length);
        }
        this.id = Arrays.copyOf(id, id.length);
    }

    @Override
    public byte[] getId() {
        return Arrays.copyOf(this.id, this.id.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.id, ((Sha256id)o).id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public String toString() {
        return Hex.printHexBinary(this.id);
    }

    public ByteString toProto() {
        return ByteString.copyFrom((byte[])this.id);
    }
}

