/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.crypto.Bn256G1Point;
import ch.epfl.dedis.lib.crypto.Bn256Scalar;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.crypto.bn256.BN;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Arrays;

public class Bn256G2Point
implements Point {
    static final byte[] marshalID = "bn256.g2".getBytes();
    BN.G2 g2;

    Bn256G2Point(BigInteger k) {
        this.g2 = new BN.G2();
        this.g2.scalarBaseMul(k);
    }

    Bn256G2Point(String pubkey) throws CothorityCryptoException {
        this(Hex.parseHexBinary(pubkey));
    }

    Bn256G2Point(byte[] b) throws CothorityCryptoException {
        if (Arrays.equals(marshalID, Arrays.copyOfRange(b, 0, 8))) {
            b = Arrays.copyOfRange(b, 8, b.length);
        }
        this.g2 = new BN.G2();
        if (this.g2.unmarshal(b) == null) {
            throw new CothorityCryptoException("invalid buffer");
        }
    }

    Bn256G2Point(BN.G2 g2) {
        this.g2 = new BN.G2(g2);
    }

    @Override
    public Point copy() {
        return new Bn256G2Point(this.g2);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Bn256G2Point)) {
            return false;
        }
        return Arrays.equals(((Bn256G2Point)other).toBytes(), this.toBytes());
    }

    @Override
    public Point mul(Scalar s) {
        if (!(s instanceof Bn256Scalar)) {
            throw new UnsupportedOperationException();
        }
        BigInteger k = new BigInteger(1, s.getBigEndian());
        BN.G2 p = new BN.G2();
        p.scalarMul(this.g2, k);
        return new Bn256G2Point(p);
    }

    @Override
    public Point add(Point other) {
        if (!(other instanceof Bn256G2Point)) {
            throw new UnsupportedOperationException();
        }
        BN.G2 p = new BN.G2();
        p.add(this.g2, ((Bn256G2Point)other).g2);
        return new Bn256G2Point(p);
    }

    @Override
    public ByteString toProto() {
        ByteString id = ByteString.copyFrom((byte[])marshalID);
        return id.concat(ByteString.copyFrom((byte[])this.toBytes()));
    }

    @Override
    public byte[] toBytes() {
        return this.g2.marshal();
    }

    @Override
    public boolean isZero() {
        return this.g2.isInfinity();
    }

    @Override
    public Point negate() {
        BN.G2 p = new BN.G2();
        p.neg(this.g2);
        return new Bn256G2Point(p);
    }

    @Override
    public byte[] data() {
        return this.g2.marshal();
    }

    @Override
    public String toString() {
        return this.g2.toString();
    }

    @Override
    public Point getZero() {
        BN.G2 p = new BN.G2();
        p.setInfinity();
        return new Bn256G2Point(p);
    }

    public BN.GT pair(Bn256G1Point g1) {
        return BN.pair(g1.g1, this.g2);
    }
}

