/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.crypto.Ed25519;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.crypto.bn256.BN;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Arrays;

public class Bn256Scalar
implements Scalar {
    private BigInteger x;

    Bn256Scalar(BigInteger x) {
        this.x = x;
    }

    Bn256Scalar(byte[] buf) {
        this.x = new BigInteger(1, buf);
    }

    @Override
    public String toString() {
        return this.x.toString();
    }

    @Override
    public ByteString toProto() {
        return ByteString.copyFrom((byte[])this.toBytes());
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = this.x.toByteArray();
        if (bytes[0] == 0) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    @Override
    public Scalar reduce() {
        return new Bn256Scalar(this.x.mod(BN.order));
    }

    @Override
    public Scalar copy() {
        return new Bn256Scalar(this.x);
    }

    @Override
    public boolean equals(Scalar other) {
        return Bn256Scalar.convert((Scalar)other).x.equals(this.x);
    }

    @Override
    public Scalar addOne() {
        return new Bn256Scalar(this.x.add(BigInteger.ONE));
    }

    @Override
    public byte[] getBigEndian() {
        return this.toBytes();
    }

    @Override
    public byte[] getLittleEndian() {
        return Ed25519.reverse(this.getBigEndian());
    }

    @Override
    public Scalar add(Scalar b) {
        return new Bn256Scalar(this.x.add(Bn256Scalar.convert((Scalar)b).x));
    }

    @Override
    public Scalar sub(Scalar b) {
        if (!(b instanceof Bn256Scalar)) {
            return this;
        }
        return new Bn256Scalar(this.x.subtract(Bn256Scalar.convert((Scalar)b).x));
    }

    @Override
    public Scalar invert() {
        return new Bn256Scalar(this.x.modInverse(BN.order));
    }

    @Override
    public Scalar negate() {
        return new Bn256Scalar(this.x.negate());
    }

    @Override
    public boolean isZero() {
        return this.x.equals(BigInteger.ZERO);
    }

    @Override
    public Scalar mul(Scalar s) {
        return new Bn256Scalar(this.x.multiply(Bn256Scalar.convert((Scalar)s).x));
    }

    private static Bn256Scalar convert(Scalar s) {
        if (!(s instanceof Bn256Scalar)) {
            throw new IllegalArgumentException(String.format("Error thrown because you are trying to operate an Bn256 with a Scalar implementing class %s", s.getClass().getName()));
        }
        return (Bn256Scalar)s;
    }
}

