/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Ed25519Scalar;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ed25519 {
    private static final Logger logger = LoggerFactory.getLogger(Ed25519.class);
    public static final int pubLen = 30;
    public static final EdDSANamedCurveSpec ed25519 = EdDSANamedCurveTable.getByName((String)"Ed25519");
    public static Curve curve = ed25519.getCurve();
    public static Field field = curve.getField();
    public static Point base = new Ed25519Point(ed25519.getB());
    public static Scalar prime_order = new Ed25519Scalar("EDD3F55C1A631258D69CF7A2DEF9DE1400000000000000000000000000000010", false);
    public static Scalar cofactor = new Ed25519Scalar("0800000000000000000000000000000000000000000000000000000000000000", false);

    public static byte[] uuid4() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        UUID uuid = UUID.randomUUID();
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static byte[] reverse(byte[] little_endian) {
        byte[] big_endian = new byte[32];
        for (int i = 0; i < 32; ++i) {
            big_endian[i] = little_endian[31 - i];
        }
        return big_endian;
    }
}

