/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import java.util.List;

public class Mask {
    private final byte[] mask;
    private final List<Point> publics;
    private Point aggregate;

    public Mask(List<Point> publics, byte[] mask) throws CothorityCryptoException {
        if (publics.size() == 0) {
            throw new CothorityCryptoException("no public keys");
        }
        this.publics = publics;
        this.mask = new byte[this.publics.size() + 7 >> 3];
        this.aggregate = publics.get(0).getZero();
        for (int i = 0; i < publics.size(); ++i) {
            byte byt = (byte)(i >> 3);
            byte msk = (byte)(1 << (i & 7));
            if ((this.mask[byt] & msk) == 0 && (mask[byt] & msk) != 0) {
                byte by = byt;
                this.mask[by] = (byte)(this.mask[by] ^ msk);
                this.aggregate = this.aggregate.add(this.publics.get(i));
            }
            if ((this.mask[byt] & msk) == 0 || (mask[byt] & msk) != 0) continue;
            byte by = byt;
            this.mask[by] = (byte)(this.mask[by] ^ msk);
            this.aggregate = this.aggregate.add(this.publics.get(i).negate());
        }
    }

    public int len() {
        return this.publics.size() + 7 >> 3;
    }

    public Point getAggregate() {
        return this.aggregate;
    }

    public boolean indexEnabled(int i) throws IndexOutOfBoundsException {
        if (i >= this.publics.size()) {
            throw new IndexOutOfBoundsException();
        }
        byte byt = (byte)(i >> 3);
        byte msk = (byte)(1 << (i & 7));
        return (this.mask[byt] & msk) != 0;
    }

    public boolean keyEnabled(Point p) throws CothorityCryptoException {
        for (int i = 0; i < this.publics.size(); ++i) {
            if (!this.publics.get(i).equals(p)) continue;
            return this.indexEnabled(i);
        }
        throw new CothorityCryptoException("key not found");
    }

    public int countEnabled() {
        int hw = 0;
        for (int i = 0; i < this.publics.size(); ++i) {
            byte byt = (byte)(i >> 3);
            byte msk = (byte)(1 << (i & 7));
            if ((this.mask[byt] & msk) == 0) continue;
            ++hw;
        }
        return hw;
    }

    public int countTotal() {
        return this.publics.size();
    }

    public String toString() {
        String out = "";
        out = out + "mask: " + Hex.printHexBinary(this.mask);
        out = out + "\npublic keys:";
        for (Point p : this.publics) {
            out = out + "\n" + p.toString();
        }
        out = out + "\naggregate: ";
        out = this.aggregate == null ? out + "null" : out + this.aggregate.toString();
        return out;
    }
}

