/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.byzcoin.contracts.DarcInstance;
import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityFactory;
import ch.epfl.dedis.lib.darc.Rule;
import ch.epfl.dedis.lib.darc.Rules;
import ch.epfl.dedis.lib.darc.Signature;
import ch.epfl.dedis.lib.exception.CothorityAlreadyExistsException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.DarcProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Darc {
    public static final String RuleSignature = "_sign";
    public static final String RuleEvolve = "invoke:" + DarcInstance.ContractId + ".evolve";
    private long version;
    private byte[] description;
    private DarcId baseID;
    private DarcId prevID;
    private Rules rules;
    private List<Signature> signatures;
    private List<Darc> verificationDarcs;
    private static final Logger logger = LoggerFactory.getLogger(Darc.class);

    public Darc(Rules rules, byte[] desc) {
        this.version = 0L;
        this.description = desc;
        this.baseID = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(new byte[0]);
            this.prevID = new DarcId(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.rules = rules;
        this.signatures = new ArrayList<Signature>();
        this.verificationDarcs = new ArrayList<Darc>();
    }

    public Darc(List<Identity> owners, List<Identity> signers, byte[] desc) {
        this(Darc.initRules(owners, signers), desc);
    }

    public Darc(DarcProto.Darc proto) throws CothorityCryptoException {
        this.version = proto.getVersion();
        this.description = proto.getDescription().toByteArray();
        if (this.version > 0L) {
            logger.info("setting baseID");
            this.baseID = new DarcId(proto.getBaseid());
        }
        this.prevID = new DarcId(proto.getPrevid());
        this.rules = new Rules(proto.getRules());
        this.signatures = new ArrayList<Signature>();
        for (DarcProto.Signature sig : proto.getSignaturesList()) {
            this.signatures.add(new Signature(sig));
        }
        logger.info("BaseID is {}", (Object)this.baseID);
    }

    public Darc(byte[] buf) throws InvalidProtocolBufferException, CothorityCryptoException {
        this(DarcProto.Darc.parseFrom(buf));
    }

    public void setRule(String action, byte[] expression) {
        try {
            if (this.rules.contains(action)) {
                this.rules.updateRule(action, expression);
            } else {
                this.rules.addRule(action, expression);
            }
        }
        catch (CothorityAlreadyExistsException | CothorityNotFoundException e) {
            throw new RuntimeException("cannot happen because we check for action existence first");
        }
    }

    public void addIdentity(String action, Identity id, String link) throws CothorityCryptoException {
        ByteArrayOutputStream newExpr = new ByteArrayOutputStream();
        try {
            if (this.rules.contains(action)) {
                newExpr.write(this.rules.get(action).getExpr());
                newExpr.write(link.getBytes());
            }
            newExpr.write(id.toString().getBytes());
            this.setRule(action, newExpr.toByteArray());
        }
        catch (IOException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public byte[] getExpression(String action) {
        Rule rule = this.rules.get(action);
        if (rule != null) {
            return Arrays.copyOf(rule.getExpr(), rule.getExpr().length);
        }
        return null;
    }

    public List<String> getActions() {
        return this.rules.getAllActions();
    }

    public byte[] removeAction(String action) {
        Rule result2 = this.rules.remove(action);
        if (result2 == null) {
            return null;
        }
        return result2.getExpr();
    }

    public DarcProto.Darc toProto() {
        DarcProto.Darc.Builder b = DarcProto.Darc.newBuilder();
        b.setVersion(this.version);
        if (this.description != null) {
            b.setDescription(ByteString.copyFrom((byte[])this.description));
        } else {
            b.setDescription(ByteString.EMPTY);
        }
        if (this.baseID != null) {
            b.setBaseid(ByteString.copyFrom((byte[])this.baseID.getId()));
        }
        b.setPrevid(ByteString.copyFrom((byte[])this.prevID.getId()));
        b.setRules(this.rules.toProto());
        this.verificationDarcs.forEach(d -> b.addVerificationdarcs(d.toProto()));
        this.signatures.forEach(s -> b.addSignatures(s.toProto()));
        return b.build();
    }

    public DarcId getId() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(Darc.longToArr8(this.version));
            digest.update(this.description);
            if (this.baseID != null) {
                digest.update(this.baseID.getId());
            }
            digest.update(this.prevID.getId());
            for (Rule rule : this.rules.getAllRules()) {
                digest.update(rule.getAction().getBytes());
                digest.update(rule.getExpr());
            }
            return new DarcId(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPrevId(DarcId id) {
        this.prevID = id;
    }

    public void setBaseId(DarcId id) {
        this.baseID = id;
    }

    public void setPrevId(Darc d) {
        this.setPrevId(d.getId());
    }

    public DarcId getBaseId() {
        if (this.version == 0L) {
            return this.getId();
        }
        return this.baseID;
    }

    public DarcId getPrevID() {
        return this.prevID;
    }

    public long getVersion() {
        return this.version;
    }

    public Darc partialCopy() {
        Rules rs = new Rules(this.rules);
        return new Darc(rs, (byte[])this.description.clone());
    }

    public Identity getIdentity() {
        return IdentityFactory.New(this);
    }

    public String toString() {
        String base = Hex.printHexBinary(this.getBaseId().getId());
        if (this.baseID != null) {
            base = String.format("stored: %s", Hex.printHexBinary(this.baseID.getId()));
        }
        String ret = String.format("Base: %s\nId: %s\nPrevId: %s\nVersion: %d\nRules:", base, Hex.printHexBinary(this.getId().getId()), Hex.printHexBinary(this.getPrevID().getId()), this.version);
        for (Rule r : this.rules.getAllRules()) {
            ret = ret + String.format("\n%s - %s", r.getAction(), new String(r.getExpr()));
        }
        ret = ret + String.format("\nDescription: %s", Hex.printHexBinary(this.description));
        return ret;
    }

    public static Rules initRules(List<Identity> owners, List<Identity> signers) {
        Rules rs = new Rules();
        if (owners != null && owners.size() > 0) {
            List ownerIDs = owners.stream().map(Identity::toString).collect(Collectors.toList());
            try {
                rs.addRule("invoke:" + DarcInstance.ContractId + ".evolve", String.join((CharSequence)" & ", ownerIDs).getBytes());
            }
            catch (CothorityAlreadyExistsException e) {
                throw new RuntimeException("this should never happen because we are adding a rule to a new object");
            }
        }
        if (signers != null && signers.size() > 0) {
            List signerIDs = signers.stream().map(Identity::toString).collect(Collectors.toList());
            try {
                rs.addRule(RuleSignature, String.join((CharSequence)" | ", signerIDs).getBytes());
            }
            catch (CothorityAlreadyExistsException e) {
                throw new RuntimeException("this should never happen because we are adding a rule to a new object");
            }
        }
        return rs;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Darc)) {
            return false;
        }
        Darc otherDarc = (Darc)other;
        return this.getBaseId().equals(otherDarc.getBaseId()) && this.version == otherDarc.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    private static byte[] longToArr8(long x) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.putLong(x);
        return b.array();
    }
}

