/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.crypto.Ed25519Pair;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Ed25519Scalar;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.crypto.SchnorrSig;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityFactory;
import ch.epfl.dedis.lib.darc.Signer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerEd25519
implements Signer {
    private Point pub;
    private Scalar priv;
    private final Logger logger = LoggerFactory.getLogger(SignerEd25519.class);

    public SignerEd25519() {
        Ed25519Pair kp = new Ed25519Pair();
        this.pub = kp.point;
        this.priv = kp.scalar;
    }

    public SignerEd25519(byte[] data) {
        this.priv = new Ed25519Scalar(data);
        this.pub = Ed25519Point.base().mul(this.priv);
    }

    @Override
    public byte[] sign(byte[] msg) {
        SchnorrSig sig = new SchnorrSig(msg, this.priv);
        return sig.toBytes();
    }

    @Override
    public Scalar getPrivate() {
        return this.priv;
    }

    @Override
    public Point getPublic() {
        return this.pub;
    }

    @Override
    public Identity getIdentity() {
        return IdentityFactory.New(this);
    }

    @Override
    public byte[] serialize() throws IOException {
        byte[] result2 = new byte[1 + this.priv.toBytes().length];
        result2[0] = 1;
        System.arraycopy(this.priv.toBytes(), 0, result2, 1, this.priv.toBytes().length);
        return result2;
    }
}

