/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.network;

import ch.epfl.dedis.lib.crypto.Ed25519;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.network.ServerIdentity;
import ch.epfl.dedis.lib.network.ServerToml;
import ch.epfl.dedis.lib.proto.NetworkProto;
import ch.epfl.dedis.lib.proto.OnetProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.moandjiezana.toml.Toml;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Roster {
    private List<ServerIdentity> nodes = new ArrayList<ServerIdentity>();
    private Point aggregate;

    public Roster(List<ServerIdentity> servers) {
        this.nodes.addAll(servers);
        this.updateAggregate();
    }

    public Roster(OnetProto.Roster roster) throws URISyntaxException {
        ArrayList<ServerIdentity> sids = new ArrayList<ServerIdentity>();
        for (NetworkProto.ServerIdentity sid : roster.getListList()) {
            sids.add(new ServerIdentity(sid));
        }
        this.nodes.addAll(sids);
        this.updateAggregate();
    }

    private void updateAggregate() {
        if (this.nodes.size() > 0) {
            this.aggregate = this.nodes.get(0).getPublic().getZero();
        }
        for (ServerIdentity serverIdentity : this.nodes) {
            this.aggregate = this.aggregate.add(serverIdentity.getPublic());
        }
    }

    public List<ServerIdentity> getNodes() {
        return this.nodes;
    }

    public List<Point> getServicePublics(String serviceName) {
        return this.nodes.stream().map(sid -> sid.getServicePublic(serviceName)).collect(Collectors.toList());
    }

    public OnetProto.Roster toProto() {
        OnetProto.Roster.Builder r = OnetProto.Roster.newBuilder();
        r.setId(ByteString.copyFrom((byte[])Ed25519.uuid4()));
        this.nodes.forEach(n -> r.addList(n.toProto()));
        r.setAggregate(this.aggregate.toProto());
        return r.build();
    }

    public ByteString sendMessage(String path, GeneratedMessageV3 proto) throws CothorityCommunicationException {
        return ByteString.copyFrom((byte[])this.nodes.get(0).SendMessage(path, proto.toByteArray()));
    }

    public ServerIdentity.StreamingConn makeStreamingConn(String path, GeneratedMessageV3 proto, ServerIdentity.StreamHandler h) throws CothorityCommunicationException {
        return this.nodes.get(0).MakeStreamingConnection(path, proto.toByteArray(), h);
    }

    public static Roster FromToml(String groupToml) {
        Toml toml = new Toml().read(groupToml);
        ArrayList<ServerIdentity> cothority = new ArrayList<ServerIdentity>();
        List servers = toml.getTables("servers");
        for (Toml srvToml : servers) {
            try {
                ServerToml srv = (ServerToml)srvToml.to(ServerToml.class);
                cothority.add(new ServerIdentity(srv));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return new Roster(cothority);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("[");
        for (int i = 0; i < this.getNodes().size(); ++i) {
            if (i != 0) {
                out.append(",");
            }
            out.append(this.getNodes().get(i).getAddress().toString());
        }
        out.append("]");
        return out.toString();
    }
}

