/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.skipchain;

import ch.epfl.dedis.lib.crypto.BlsSig;
import ch.epfl.dedis.lib.crypto.Bn256G2Point;
import ch.epfl.dedis.lib.crypto.Mask;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;

public class ByzcoinSig {
    private SkipchainProto.ByzcoinSig byzcoinSig;

    public ByzcoinSig(SkipchainProto.ByzcoinSig bs) {
        this.byzcoinSig = bs;
    }

    public ByzcoinSig(byte[] buf) throws InvalidProtocolBufferException {
        this.byzcoinSig = SkipchainProto.ByzcoinSig.parseFrom(buf);
    }

    public ByzcoinSig(ByteString bs) throws InvalidProtocolBufferException {
        this.byzcoinSig = SkipchainProto.ByzcoinSig.parseFrom(bs);
    }

    public boolean verify(List<Point> publics) {
        Mask mask;
        if (publics == null || publics.size() == 0) {
            return false;
        }
        if (this.getMsg() == null) {
            return false;
        }
        if (this.getSignature() == null || this.getSignature().length == 0) {
            return false;
        }
        int lenCom = 64;
        byte[] signature = Arrays.copyOf(this.getSignature(), lenCom);
        if (lenCom >= this.getSignature().length) {
            return false;
        }
        byte[] maskBits = Arrays.copyOfRange(this.getSignature(), lenCom, this.getSignature().length);
        try {
            mask = new Mask(publics, maskBits);
        }
        catch (CothorityCryptoException e) {
            return false;
        }
        BlsSig blsSig = new BlsSig(signature);
        if (!blsSig.verify(this.getMsg(), (Bn256G2Point)mask.getAggregate())) {
            return false;
        }
        int n = publics.size();
        int threshold = n - (n - 1) / 3;
        return mask.countEnabled() >= threshold;
    }

    public byte[] getMsg() {
        return this.byzcoinSig.getMsg().toByteArray();
    }

    public byte[] getSignature() {
        return this.byzcoinSig.getSig().toByteArray();
    }
}

