/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.skipchain;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.network.Roster;
import ch.epfl.dedis.lib.network.ServerIdentity;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipchainRPC {
    protected SkipblockId scID;
    protected Roster roster;
    private final Logger logger = LoggerFactory.getLogger(SkipchainRPC.class);
    public static final String SERVICE_NANE = "Skipchain";

    public SkipchainRPC(Roster roster, SkipblockId scID) throws CothorityCommunicationException {
        this.scID = scID;
        this.roster = roster;
    }

    public boolean checkStatus() {
        boolean ok = true;
        for (ServerIdentity n : this.roster.getNodes()) {
            this.logger.info("Testing node {}", (Object)n.getAddress());
            try {
                n.GetStatus();
            }
            catch (CothorityCommunicationException e) {
                this.logger.warn("Failing node {}", (Object)n.getAddress());
                ok = false;
            }
        }
        return ok;
    }

    public SkipBlock getSkipblock(SkipblockId id) throws CothorityCommunicationException {
        SkipchainProto.GetSingleBlock request = SkipchainProto.GetSingleBlock.newBuilder().setId(ByteString.copyFrom((byte[])id.getId())).build();
        ByteString msg = this.roster.sendMessage("Skipchain/GetSingleBlock", request);
        try {
            SkipchainProto.SkipBlock sb = SkipchainProto.SkipBlock.parseFrom(msg);
            SkipBlock ret = new SkipBlock(sb);
            if (!ret.verifyForwardSignatures()) {
                throw new CothorityCommunicationException("invalid forward signatures");
            }
            this.logger.debug("Got the following skipblock: {}", (Object)sb);
            this.logger.info("Successfully read skipblock");
            return ret;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public List<SkipBlock> getUpdateChain() throws CothorityCommunicationException, CothorityCryptoException {
        return this.getUpdateChain(this.scID);
    }

    public List<SkipBlock> getUpdateChain(SkipblockId trustedLatest) throws CothorityCommunicationException, CothorityCryptoException {
        ArrayList<SkipBlock> update = new ArrayList<SkipBlock>();
        while (true) {
            SkipchainProto.GetUpdateChainReply r2;
            try {
                SkipchainProto.GetUpdateChain request = SkipchainProto.GetUpdateChain.newBuilder().setLatestID(ByteString.copyFrom((byte[])trustedLatest.getId())).build();
                ByteString msg = this.roster.sendMessage("Skipchain/GetUpdateChain", request);
                r2 = SkipchainProto.GetUpdateChainReply.parseFrom(msg);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CothorityCommunicationException(e);
            }
            SkipBlock start = new SkipBlock(r2.getUpdateList().get(0));
            if (!trustedLatest.equals(start.getId())) {
                throw new CothorityCryptoException("first returned block does not match requested hash");
            }
            for (int j = 0; j < r2.getUpdateCount(); ++j) {
                SkipBlock b = new SkipBlock(r2.getUpdateList().get(j));
                if (j == 0 && update.size() > 0 && Arrays.equals(((SkipBlock)update.get(update.size() - 1)).getHash(), b.getHash())) continue;
                if (!b.verifyForwardSignatures()) {
                    throw new CothorityCryptoException("forward signature verification failed");
                }
                if (update.size() > 0) {
                    if (b.getBackLinks().size() == 0) {
                        throw new CothorityCryptoException("no backlink");
                    }
                    SkipBlock prevBlock = (SkipBlock)update.get(update.size() - 1);
                    int link = prevBlock.getHeight();
                    if (link > b.getHeight()) {
                        link = b.getHeight();
                    }
                    if (!b.getBackLinks().get(link - 1).equals(prevBlock.getId())) {
                        throw new CothorityCryptoException("corresponding backlink doesn't point to previous block");
                    }
                    if (!prevBlock.getForwardLinks().get(link - 1).getTo().equals(b.getId())) {
                        throw new CothorityCryptoException("corresponding forwardlink doesn't point to next block");
                    }
                }
                update.add(b);
            }
            SkipBlock last = (SkipBlock)update.get(update.size() - 1);
            if (last.getForwardLinks().size() == 0) {
                this.logger.info("Got the following latest skipblock: {}", (Object)Hex.printHexBinary(last.getId().getId()));
                return update;
            }
            try {
                Roster tmp = last.getForwardLinks().get(last.getForwardLinks().size() - 1).getNewRoster();
                if (tmp == null) {
                    this.roster = last.getRoster();
                    continue;
                }
                this.roster = last.getForwardLinks().get(last.getForwardLinks().size() - 1).getNewRoster();
            }
            catch (URISyntaxException e) {
                throw new CothorityCryptoException(e.getMessage());
            }
        }
    }

    public SkipblockId getID() {
        return this.scID;
    }

    public Roster getRoster() {
        return this.roster;
    }
}

