/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzgen;

import ch.epfl.dedis.byzgen.OnchainSecrets;
import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class OcsFactory {
    private ArrayList<ServerIdentity> servers = new ArrayList();
    private SkipblockId genesis;

    public OcsFactory setGenesis(SkipblockId genesis) {
        this.genesis = genesis;
        return this;
    }

    public OcsFactory addConode(URI conode, String publicKey) {
        if (!conode.getScheme().equals("tcp")) {
            throw new IllegalArgumentException("conode address must be in tcp format like \"tcp://127.0.0.0:7001\"");
        }
        this.servers.add(new ServerIdentity(conode, publicKey));
        return this;
    }

    public OcsFactory addConode(ConodeAddress conode) {
        return this.addConode(conode.getAddress(), conode.getPublicKey());
    }

    public OcsFactory addConodes(Collection<ConodeAddress> conodes) {
        for (ConodeAddress conodeAddress : conodes) {
            this.addConode(conodeAddress);
        }
        return this;
    }

    public OnchainSecrets createConnection() throws CothorityCommunicationException {
        if (null == this.genesis) {
            throw new IllegalStateException("Connection can not be established. No genesis specified.");
        }
        try {
            return new OnchainSecrets(this.createRoster(), this.genesis);
        }
        catch (CothorityCryptoException e) {
            throw new CothorityCommunicationException("Unable to connect to cothority ", e);
        }
    }

    public SkipblockId initialiseNewSkipchain(Signer admin) throws CothorityCommunicationException {
        try {
            Roster roster = this.createRoster();
            Darc adminDarc = this.createAdminDarc(admin);
            OnchainSecrets ocs = new OnchainSecrets(roster, adminDarc);
            return ocs.getGenesis();
        }
        catch (CothorityCryptoException e) {
            throw new CothorityCommunicationException("Unable to create a new skipchain", e);
        }
    }

    private Roster createRoster() {
        if (this.servers.size() < 1) {
            throw new IllegalStateException("Connection can not be established. No cothority server was specified.");
        }
        return new Roster(this.servers);
    }

    private Darc createAdminDarc(Signer admin) throws CothorityCommunicationException {
        try {
            return new Darc(admin, null, null);
        }
        catch (CothorityCryptoException e) {
            throw new CothorityCommunicationException("Unable to create admin DARC for a new skipchain", e);
        }
    }

    public static class ConodeAddress {
        private final URI address;
        private final String publicKey;

        public URI getAddress() {
            return this.address;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public ConodeAddress(URI address, String publicKey) {
            this.address = address;
            this.publicKey = publicKey;
        }
    }
}

