/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib;

import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.crypto.Ed25519;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.proto.NetworkProto;
import ch.epfl.dedis.proto.OnetProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.moandjiezana.toml.Toml;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class Roster {
    private List<ServerIdentity> nodes = new ArrayList<ServerIdentity>();
    private Point aggregate;

    public Roster(List<ServerIdentity> servers) {
        this.nodes.addAll(servers);
        this.updateAggregate();
    }

    public Roster(OnetProto.Roster roster) throws URISyntaxException {
        ArrayList<ServerIdentity> sids = new ArrayList<ServerIdentity>();
        for (NetworkProto.ServerIdentity sid : roster.getListList()) {
            sids.add(new ServerIdentity(sid));
        }
        this.nodes.addAll(sids);
        this.updateAggregate();
    }

    private void updateAggregate() {
        for (ServerIdentity serverIdentity : this.nodes) {
            if (this.aggregate == null) {
                this.aggregate = serverIdentity.Public;
                continue;
            }
            this.aggregate = this.aggregate.add(serverIdentity.Public);
        }
    }

    public List<ServerIdentity> getNodes() {
        return this.nodes;
    }

    public OnetProto.Roster toProto() {
        OnetProto.Roster.Builder r = OnetProto.Roster.newBuilder();
        r.setId(ByteString.copyFrom((byte[])Ed25519.uuid4()));
        this.nodes.forEach(n -> r.addList(n.toProto()));
        r.setAggregate(this.aggregate.toProto());
        return r.build();
    }

    public ByteString sendMessage(String path, GeneratedMessageV3 proto) throws CothorityCommunicationException {
        return ByteString.copyFrom((byte[])this.nodes.get(0).SendMessage(path, proto.toByteArray()));
    }

    public static Roster FromToml(String groupToml) {
        Toml toml = new Toml().read(groupToml);
        ArrayList<ServerIdentity> cothority = new ArrayList<ServerIdentity>();
        List servers = toml.getTables("servers");
        for (Toml s : servers) {
            try {
                cothority.add(new ServerIdentity(s));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return new Roster(cothority);
    }
}

