/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib;

import ch.epfl.dedis.lib.UUIDType5;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.proto.NetworkProto;
import ch.epfl.dedis.proto.StatusProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.moandjiezana.toml.Toml;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIdentity {
    private final URI conodeAddress;
    public Point Public;
    private final Logger logger = LoggerFactory.getLogger(ServerIdentity.class);

    public ServerIdentity(URI serverWsAddress, String publicKey) {
        this.conodeAddress = serverWsAddress;
        this.Public = new Ed25519Point(Hex.parseHexBinary(publicKey));
    }

    public ServerIdentity(Toml siToml) throws URISyntaxException {
        this(new URI(siToml.getString("Address")), siToml.getString("Public"));
    }

    public ServerIdentity(NetworkProto.ServerIdentity sid) throws URISyntaxException {
        this(new URI(sid.getAddress()), Hex.printHexBinary(sid.getPublic().toByteArray()));
    }

    public URI getAddress() {
        return this.conodeAddress;
    }

    public StatusProto.Response GetStatus() throws CothorityCommunicationException {
        StatusProto.Request request = StatusProto.Request.newBuilder().build();
        try {
            SyncSendMessage msg = new SyncSendMessage("Status/Request", request.toByteArray());
            return StatusProto.Response.parseFrom(msg.response);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e.toString());
        }
    }

    public NetworkProto.ServerIdentity toProto() {
        NetworkProto.ServerIdentity.Builder si = NetworkProto.ServerIdentity.newBuilder();
        si.setPublic(this.Public.toProto());
        String pubStr = "https://dedis.epfl.ch/id/" + this.Public.toString().toLowerCase();
        byte[] id = UUIDType5.toBytes(UUIDType5.nameUUIDFromNamespaceAndString(UUIDType5.NAMESPACE_URL, pubStr));
        si.setId(ByteString.copyFrom((byte[])id));
        si.setAddress(this.getAddress().toString());
        si.setDescription("");
        return si.build();
    }

    public byte[] SendMessage(String path, byte[] data) throws CothorityCommunicationException {
        SyncSendMessage ssm = new SyncSendMessage(path, data);
        if (ssm.response == null) {
            throw new CothorityCommunicationException("Error while retrieving response - try again. Error-string is: " + ssm.error);
        }
        return ssm.response.array();
    }

    public class SyncSendMessage {
        public ByteBuffer response;
        public String error;

        public SyncSendMessage(String path, final byte[] msg) throws CothorityCommunicationException {
            final CountDownLatch statusLatch = new CountDownLatch(1);
            try {
                WebSocketClient ws = new WebSocketClient(this.buildWebSocketAdddress(path)){

                    public void onMessage(String msg2) {
                        SyncSendMessage.this.error = "This should never happen:" + msg2;
                        statusLatch.countDown();
                    }

                    public void onMessage(ByteBuffer message) {
                        SyncSendMessage.this.response = message;
                        this.close();
                        statusLatch.countDown();
                    }

                    public void onOpen(ServerHandshake handshake) {
                        this.send(msg);
                    }

                    public void onClose(int code, String reason, boolean remote) {
                        if (reason != "") {
                            SyncSendMessage.this.error = reason;
                        }
                        statusLatch.countDown();
                    }

                    public void onError(Exception ex) {
                        SyncSendMessage.this.error = "Error: " + ex.toString();
                        statusLatch.countDown();
                    }
                };
                ws.connect();
                statusLatch.await();
            }
            catch (InterruptedException e) {
                throw new CothorityCommunicationException(e.toString());
            }
            catch (URISyntaxException e) {
                throw new CothorityCommunicationException(e.toString());
            }
            if (this.error != null) {
                ServerIdentity.this.logger.error("error: {}", (Object)this.error);
                throw new CothorityCommunicationException(this.error);
            }
        }

        private URI buildWebSocketAdddress(String servicePath) throws URISyntaxException {
            return new URI("ws", ServerIdentity.this.conodeAddress.getUserInfo(), ServerIdentity.this.conodeAddress.getHost(), ServerIdentity.this.conodeAddress.getPort() + 1, servicePath.startsWith("/") ? servicePath : "/".concat(servicePath), ServerIdentity.this.conodeAddress.getQuery(), ServerIdentity.this.conodeAddress.getFragment());
        }
    }
}

