/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib;

import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.proto.SkipchainProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;

public class SkipBlock {
    private SkipchainProto.SkipBlock skipBlock;

    public SkipBlock(SkipchainProto.SkipBlock skipBlock) {
        this.skipBlock = skipBlock;
    }

    public SkipBlock(byte[] sb) throws CothorityException {
        try {
            this.skipBlock = SkipchainProto.SkipBlock.parseFrom(sb);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityException(e);
        }
    }

    public SkipchainProto.SkipBlock getProto() {
        return this.skipBlock;
    }

    public byte[] toByteArray() {
        return this.skipBlock.toByteArray();
    }

    public byte[] getHash() {
        return this.skipBlock.getHash().toByteArray();
    }

    public SkipblockId getId() throws CothorityCryptoException {
        return new SkipblockId(this.getHash());
    }

    public SkipblockId getSkipchainId() throws CothorityCryptoException {
        if (this.skipBlock.getIndex() == 0) {
            return this.getId();
        }
        return new SkipblockId(this.skipBlock.getGenesis().toByteArray());
    }

    public byte[] getData() {
        return this.skipBlock.getData().toByteArray();
    }

    public int getIndex() {
        return this.skipBlock.getIndex() / 2;
    }

    public Roster getRoster() throws CothorityException {
        try {
            return new Roster(this.skipBlock.getRoster());
        }
        catch (URISyntaxException e) {
            throw new CothorityException(e);
        }
    }
}

