/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.crypto;

import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Ed25519Scalar;
import ch.epfl.dedis.lib.crypto.KeyPair;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.proto.SkipchainProto;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class SchnorrSig {
    public Point challenge;
    public Scalar response;

    public SchnorrSig(byte[] msg, Scalar priv) {
        KeyPair kp = new KeyPair();
        this.challenge = kp.point;
        Point pub = Ed25519Point.base().mul(priv);
        Scalar xh = priv.mul(this.toHash(this.challenge, pub, msg));
        this.response = kp.scalar.add(xh);
    }

    public SchnorrSig(byte[] data) {
        this.challenge = new Ed25519Point(Arrays.copyOfRange(data, 0, 32));
        this.response = new Ed25519Scalar(Arrays.copyOfRange(data, 32, 64));
    }

    public boolean verify(byte[] msg, Point pub) {
        Scalar hash = this.toHash(this.challenge, pub, msg);
        Point S = Ed25519Point.base().mul(this.response);
        Point Ah = pub.mul(hash);
        Point RAs = this.challenge.add(Ah);
        return S.equals(RAs);
    }

    public byte[] toBytes() {
        byte[] buf = new byte[64];
        System.arraycopy(this.challenge.toBytes(), 0, buf, 0, 32);
        System.arraycopy(this.response.toBytes(), 0, buf, 32, 32);
        return buf;
    }

    public Scalar toHash(Point challenge, Point pub, byte[] msg) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            digest.update(challenge.toBytes());
            digest.update(pub.toBytes());
            digest.update(msg);
            byte[] hash = Arrays.copyOfRange(digest.digest(), 0, 64);
            Ed25519Scalar s = new Ed25519Scalar(hash);
            return s;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public SkipchainProto.SchnorrSig toProto() {
        SkipchainProto.SchnorrSig.Builder ss = SkipchainProto.SchnorrSig.newBuilder();
        ss.setChallenge(this.challenge.toProto());
        ss.setResponse(this.response.toProto());
        return ss.build();
    }
}

