/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.DarcSignature;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityFactory;
import ch.epfl.dedis.lib.darc.SignaturePath;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.proto.DarcOCSProto;
import com.google.protobuf.ByteString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Darc {
    public List<Identity> owners;
    private List<Identity> users;
    private byte[] data;
    private int version;
    private DarcId baseid;
    private DarcSignature signature;
    private final Logger logger = LoggerFactory.getLogger(Darc.class);

    public Darc(List<Identity> owners, List<Identity> users, byte[] data) throws CothorityCryptoException {
        this();
        this.version = 0;
        if (owners != null) {
            this.owners = new ArrayList<Identity>(owners);
        }
        if (users != null) {
            this.users = new ArrayList<Identity>(users);
        }
        this.setDataAndInitBase(data);
    }

    public Darc(Identity owner, List<Identity> users, byte[] data) throws CothorityException {
        this();
        this.version = 0;
        this.owners.add(owner);
        if (users != null) {
            this.users = new ArrayList<Identity>(users);
        }
        this.setDataAndInitBase(data);
    }

    public Darc(Signer owner, List<Signer> users, byte[] data) throws CothorityCryptoException {
        this();
        this.version = 0;
        this.owners.add(IdentityFactory.New(owner));
        if (users != null) {
            for (Signer s : users) {
                this.users.add(IdentityFactory.New(s));
            }
        }
        this.setDataAndInitBase(data);
    }

    public Darc() {
        this.owners = new ArrayList<Identity>();
        this.users = new ArrayList<Identity>();
    }

    private void setDataAndInitBase(byte[] data) throws CothorityCryptoException {
        this.data = data;
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        this.baseid = new DarcId(bytes);
    }

    public Darc(DarcOCSProto.Darc proto) throws CothorityCryptoException {
        this();
        for (DarcOCSProto.Identity owner : proto.getOwnersList()) {
            this.owners.add(IdentityFactory.New(owner));
        }
        for (DarcOCSProto.Identity user : proto.getUsersList()) {
            this.users.add(IdentityFactory.New(user));
        }
        this.version = proto.getVersion();
        if (proto.hasDescription()) {
            this.data = proto.getDescription().toByteArray();
        }
        if (proto.hasSignature()) {
            this.signature = new DarcSignature(proto.getSignature());
        }
        if (proto.hasBaseid()) {
            this.baseid = new DarcId(proto.getBaseid().toByteArray());
        }
    }

    public Darc copy() throws CothorityCryptoException {
        Darc d = new Darc(this.owners, this.users, this.data);
        d.version = this.version;
        d.baseid = this.baseid;
        return d;
    }

    public DarcId getId() throws CothorityCryptoException {
        Darc c = this.copy();
        DarcOCSProto.Darc proto = c.toProto();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(proto.toByteArray());
            return new DarcId(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public void setEvolution(Darc previous, Signer previousOwner) throws CothorityCryptoException {
        this.version = previous.version + 1;
        SignaturePath path = new SignaturePath(previousOwner, 0);
        this.baseid = previous.getBaseId();
        this.signature = new DarcSignature(this.getId().getId(), path, previousOwner);
        this.logger.debug("Signature is: " + this.signature.toProto().toString());
    }

    public void setEvolutionOffline(Darc previous, SignaturePath path, Signer previousOwner) throws CothorityCryptoException {
        this.version = previous.version + 1;
        if (path == null) {
            path = new SignaturePath(previous, previousOwner, 0);
        }
        boolean found = false;
        Identity signerId = IdentityFactory.New(previousOwner);
        for (Identity id : path.getDarcs().get((int)(path.getDarcs().size() - 1)).owners) {
            if (!id.equals(signerId)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new CothorityCryptoException("Wrong path: signer is not in last darc.");
        }
        this.baseid = previous.getBaseId();
        this.signature = new DarcSignature(this.getId().getId(), path, previousOwner);
        this.logger.debug("Signature is: " + this.signature.toProto().toString());
    }

    public DarcId getBaseId() throws CothorityCryptoException {
        if (this.version > 0) {
            return this.baseid;
        }
        return this.getId();
    }

    public boolean verifyEvolution(Darc previous) throws CothorityCryptoException {
        if (this.signature == null) {
            return false;
        }
        return this.signature.verify(this.getId().getId(), previous);
    }

    public DarcOCSProto.Darc toProto() {
        DarcOCSProto.Darc.Builder b = DarcOCSProto.Darc.newBuilder();
        for (Identity i : this.owners) {
            b.addOwners(i.toProto());
        }
        for (Identity i : this.users) {
            b.addUsers(i.toProto());
        }
        if (this.signature != null) {
            b.setSignature(this.signature.toProto());
        }
        b.setVersion(this.version);
        if (this.data != null) {
            b.setDescription(ByteString.copyFrom((byte[])this.data));
        }
        if (this.baseid != null) {
            b.setBaseid(ByteString.copyFrom((byte[])this.baseid.getId()));
        }
        return b.build();
    }

    public void addUser(Identity identity) {
        this.users.add(identity);
    }

    public void addUser(Darc darc) throws CothorityCryptoException {
        this.addUser(IdentityFactory.New(darc));
    }

    public void addUser(Signer signer) throws CothorityCryptoException {
        this.addUser(IdentityFactory.New(signer));
    }

    public void removeOwner(Identity identity) {
        this.owners.remove(identity);
    }

    public void removeOwner(Darc darc) throws CothorityCryptoException {
        this.owners.remove(IdentityFactory.New(darc));
    }

    public void removeOwner(Signer signer) throws CothorityCryptoException {
        this.owners.remove(IdentityFactory.New(signer));
    }

    public void removeUser(Identity identity) {
        this.users.remove(identity);
    }

    public void removeUser(Darc darc) throws CothorityCryptoException {
        this.users.remove(IdentityFactory.New(darc));
    }

    public void removeUser(Signer signer) throws CothorityCryptoException {
        this.users.remove(IdentityFactory.New(signer));
    }

    public void addOwner(Identity identity) {
        this.owners.add(identity);
    }

    public void addOwner(Darc darc) throws CothorityCryptoException {
        this.addOwner(IdentityFactory.New(darc));
    }

    public void addOwner(Signer signer) throws CothorityCryptoException {
        this.addOwner(IdentityFactory.New(signer));
    }

    public void incVersion() {
        ++this.version;
    }

    public int getVersion() {
        return this.version;
    }

    public List<Identity> getOwners() {
        return new ArrayList<Identity>(this.owners);
    }

    public List<Identity> getUsers() {
        return new ArrayList<Identity>(this.users);
    }

    public byte[] getData() {
        if (this.data == null) {
            return null;
        }
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String toString() {
        try {
            String ret = String.format("getId: %s\n", this.getId().toString());
            if (this.baseid != null) {
                ret = ret + String.format("BaseID: %s\n", this.baseid.toString());
            }
            for (Identity i : this.owners) {
                ret = ret + String.format("owner: %s\n", i.toString());
            }
            for (Identity i : this.users) {
                ret = ret + String.format("user: %s\n", i.toString());
            }
            return ret;
        }
        catch (CothorityCryptoException e) {
            return "Error when creating string: " + e.toString();
        }
    }

    public boolean equals(Darc d) {
        try {
            return this.getId().equals(d.getId());
        }
        catch (CothorityCryptoException e) {
            return false;
        }
    }
}

