/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.SignaturePath;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.proto.DarcOCSProto;
import com.google.protobuf.ByteString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarcSignature {
    private byte[] signature;
    private SignaturePath path;
    private final Logger logger = LoggerFactory.getLogger(DarcSignature.class);

    public DarcSignature(byte[] msg, SignaturePath path, Signer signer) throws CothorityCryptoException {
        this.path = path;
        try {
            this.signature = signer.sign(this.getHash(msg));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException("Ugly user does not sign a request ", e);
        }
    }

    public DarcSignature(byte[] msg, Darc darc, Signer signer, int role) throws CothorityCryptoException {
        this.path = new SignaturePath(darc, signer, role);
        try {
            this.signature = signer.sign(this.getHash(msg));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException("Ugly user does not sign a request ", e);
        }
    }

    public DarcSignature(DarcOCSProto.Signature proto) throws CothorityCryptoException {
        this.signature = proto.getSignature().toByteArray();
        this.path = new SignaturePath(proto.getSignaturepath());
    }

    public SignaturePath getPath() {
        return this.path;
    }

    public boolean verify(byte[] msg, Darc base) throws CothorityCryptoException {
        if (this.path.getPathIDs().size() == 0) {
            throw new CothorityCryptoException("cannot verify if path is not set - is this an online signature?");
        }
        if (!this.path.getPathIDs().get(0).equals(base.getId())) {
            return false;
        }
        return this.path.getSigner().verify(this.getHash(msg), this.signature);
    }

    public DarcOCSProto.Signature toProto() {
        DarcOCSProto.Signature.Builder b = DarcOCSProto.Signature.newBuilder();
        b.setSignature(ByteString.copyFrom((byte[])this.signature));
        b.setSignaturepath(this.path.toProto());
        return b.build();
    }

    private byte[] getHash(byte[] msg) throws CothorityCryptoException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            this.logger.debug("path: " + Hex.printHexBinary(this.path.getPathMsg()));
            this.logger.debug("msg: " + Hex.printHexBinary(msg));
            digest.update(this.path.getPathMsg());
            digest.update(msg);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CothorityCryptoException("couldn't make hash: " + e.toString());
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof DarcSignature)) {
            return false;
        }
        DarcSignature otherSig = (DarcSignature)other;
        return Arrays.equals(otherSig.signature, this.signature) && otherSig.path.equals(this.path);
    }
}

