/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityDarc;
import ch.epfl.dedis.lib.darc.IdentityEd25519;
import ch.epfl.dedis.lib.darc.IdentityX509EC;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.darc.SignerEd25519;
import ch.epfl.dedis.lib.darc.SignerX509EC;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.proto.DarcOCSProto;

public class IdentityFactory {
    public static Identity New(DarcOCSProto.Identity proto) throws CothorityCryptoException {
        if (proto.hasEd25519()) {
            return new IdentityEd25519(proto.getEd25519());
        }
        if (proto.hasDarc()) {
            return new IdentityDarc(proto.getDarc());
        }
        if (proto.hasX509Ec()) {
            return new IdentityX509EC(proto.getX509Ec());
        }
        throw new CothorityCryptoException("No identity present");
    }

    public static Identity New(Signer signer) throws CothorityCryptoException {
        if (SignerEd25519.class.isInstance(signer)) {
            return new IdentityEd25519(signer);
        }
        if (SignerX509EC.class.isInstance(signer)) {
            return new IdentityX509EC(signer);
        }
        throw new CothorityCryptoException("Cannot make Identity out of " + signer.toString());
    }

    public static Identity New(Darc darc) throws CothorityCryptoException {
        return new IdentityDarc(darc);
    }
}

