/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityFactory;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.proto.DarcOCSProto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignaturePath {
    public static final int OWNER = 0;
    public static final int USER = 1;
    private List<Darc> path;
    private Identity signer;
    private int role;
    private final Logger logger = LoggerFactory.getLogger(SignaturePath.class);

    public SignaturePath(List<Darc> darcPath, Identity signer, int role) {
        this.path = darcPath;
        this.signer = signer;
        this.role = role;
    }

    public SignaturePath(List<Darc> darcPath, Signer signer, int role) throws CothorityCryptoException {
        this(darcPath, IdentityFactory.New(signer), role);
    }

    public SignaturePath(Darc darc, Signer signer, int role) throws CothorityCryptoException {
        this.path = new ArrayList<Darc>();
        this.path.add(darc);
        this.signer = IdentityFactory.New(signer);
        this.role = role;
    }

    public SignaturePath(Signer signer, int role) throws CothorityCryptoException {
        this.path = new ArrayList<Darc>();
        this.signer = IdentityFactory.New(signer);
        this.role = role;
    }

    public SignaturePath(DarcOCSProto.SignaturePath proto) throws CothorityCryptoException {
        this.role = proto.getRole();
        this.signer = IdentityFactory.New(proto.getSigner());
        this.path = new ArrayList<Darc>();
        for (DarcOCSProto.Darc d : proto.getDarcsList()) {
            this.path.add(new Darc(d));
        }
    }

    public byte[] getPathMsg() throws CothorityCryptoException {
        if (this.path.size() == 0) {
            return "online".getBytes();
        }
        byte[] pathMsg = new byte[this.path.size() * this.path.get(0).getId().getId().length];
        int pos = 0;
        for (Darc d : this.path) {
            System.arraycopy(d.getId().getId(), 0, pathMsg, pos * 32, 32);
            ++pos;
        }
        return pathMsg;
    }

    public List<DarcId> getPathIDs() {
        ArrayList<DarcId> ids = new ArrayList<DarcId>();
        for (Darc d : this.path) {
            try {
                ids.add(d.getId());
            }
            catch (CothorityCryptoException cothorityCryptoException) {}
        }
        return ids;
    }

    public List<Darc> getDarcs() {
        ArrayList<Darc> darcs = new ArrayList<Darc>();
        for (Darc d : this.path) {
            darcs.add(d);
        }
        return darcs;
    }

    public Identity getSigner() {
        return this.signer;
    }

    public DarcOCSProto.SignaturePath toProto() {
        DarcOCSProto.SignaturePath.Builder b = DarcOCSProto.SignaturePath.newBuilder();
        b.setRole(this.role);
        b.setSigner(this.signer.toProto());
        for (Darc d : this.path) {
            b.addDarcs(d.toProto());
        }
        return b.build();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof SignaturePath)) {
            return false;
        }
        SignaturePath otherPath = (SignaturePath)other;
        boolean paths = true;
        for (int i = 0; i < this.path.size(); ++i) {
            if (this.path.get(i).equals(otherPath.path.get(i))) continue;
            paths = false;
            break;
        }
        return otherPath.role == this.role && otherPath.signer.equals(this.signer) && paths;
    }
}

