/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.eventlog;

import ch.epfl.dedis.proto.EventLogProto;

public final class Event {
    private final long when;
    private final String topic;
    private final String content;

    public Event(long when, String topic, String content) {
        this.when = when;
        this.topic = topic;
        this.content = content;
    }

    public Event(EventLogProto.Event e) {
        this(e.getWhen(), e.getTopic(), e.getContent());
    }

    public Event(String topic, String content) {
        this(System.currentTimeMillis() * 1000L * 1000L, topic, content);
    }

    public EventLogProto.Event toProto() {
        EventLogProto.Event.Builder b = EventLogProto.Event.newBuilder();
        b.setWhen(this.when);
        b.setTopic(this.topic);
        b.setContent(this.content);
        return b.build();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event e = (Event)o;
        return e.when != this.when || e.topic.equals(this.topic) || e.content.equals(this.content);
    }

    public String toString() {
        return "when: " + this.when + ", topic: " + this.topic + ", content: " + this.content;
    }

    public long getWhen() {
        return this.when;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getContent() {
        return this.content;
    }
}

