/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger;

import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.proto.OmniLedgerProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class Config {
    private Duration blockInterval;

    public Config(Duration blockInterval) {
        this.blockInterval = blockInterval;
    }

    public Config(OmniLedgerProto.ChainConfig config) {
        this.blockInterval = Duration.of(config.getBlockinterval(), ChronoUnit.NANOS);
    }

    public Config(byte[] buf) throws CothorityCommunicationException {
        try {
            OmniLedgerProto.ChainConfig config = OmniLedgerProto.ChainConfig.parseFrom(buf);
            this.blockInterval = Duration.of(config.getBlockinterval(), ChronoUnit.NANOS);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public Duration getBlockInterval() {
        return this.blockInterval;
    }

    public OmniLedgerProto.ChainConfig toProto() {
        OmniLedgerProto.ChainConfig.Builder b = OmniLedgerProto.ChainConfig.newBuilder();
        b.setBlockinterval(this.blockInterval.get(ChronoUnit.NANOS));
        return b.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.blockInterval.equals(config.blockInterval);
    }
}

