/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger;

import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.omniledger.InstanceId;
import ch.epfl.dedis.lib.omniledger.Proof;
import java.util.List;

public class Instance {
    private InstanceId id;
    private String contractId;
    private byte[] data;

    public Instance(Proof p) throws CothorityException {
        if (!p.matches()) {
            throw new CothorityNotFoundException("this is a proof of absence");
        }
        this.id = new InstanceId(p.getKey());
        List<byte[]> values = p.getValues();
        this.data = values.get(0);
        this.contractId = new String(values.get(1));
    }

    public InstanceId getId() {
        return this.id;
    }

    public String getContractId() {
        return this.contractId;
    }

    public byte[] getData() {
        return this.data;
    }
}

