/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger;

import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.omniledger.ClientTransaction;
import ch.epfl.dedis.lib.omniledger.Config;
import ch.epfl.dedis.lib.omniledger.InstanceId;
import ch.epfl.dedis.lib.omniledger.Proof;
import ch.epfl.dedis.lib.omniledger.SubId;
import ch.epfl.dedis.lib.omniledger.darc.Darc;
import ch.epfl.dedis.lib.omniledger.darc.DarcId;
import ch.epfl.dedis.lib.skipchain.SkipchainRPC;
import ch.epfl.dedis.proto.OmniLedgerProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniledgerRPC {
    private Config config;
    private Roster roster;
    private Darc genesisDarc;
    private SkipBlock genesis;
    private SkipBlock latest;
    private SkipchainRPC skipchain;
    public static final int currentVersion = 1;
    private final Logger logger = LoggerFactory.getLogger(OmniledgerRPC.class);

    public OmniledgerRPC(Roster r, Darc d, Duration blockInterval) throws CothorityException {
        OmniLedgerProto.CreateGenesisBlock.Builder request = OmniLedgerProto.CreateGenesisBlock.newBuilder();
        request.setVersion(1);
        request.setRoster(r.toProto());
        request.setGenesisdarc(d.toProto());
        request.setBlockinterval(blockInterval.get(ChronoUnit.NANOS));
        ByteString msg = r.sendMessage("OmniLedger/CreateGenesisBlock", request.build());
        try {
            OmniLedgerProto.CreateGenesisBlockResponse reply = OmniLedgerProto.CreateGenesisBlockResponse.parseFrom(msg);
            this.genesis = new SkipBlock(reply.getSkipblock());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
        this.latest = this.genesis;
        this.logger.info("Created new OmniLedger: {}", (Object)this.genesis.getId().toString());
        this.skipchain = new SkipchainRPC(r, this.genesis.getId());
        this.config = new Config(blockInterval);
        this.roster = r;
        this.genesisDarc = d;
    }

    public OmniledgerRPC(Roster roster, SkipblockId skipchainId) throws CothorityException {
        Proof proof = OmniledgerRPC.getProof(roster, skipchainId, InstanceId.zero());
        OmniledgerRPC.checkProof(proof, "config");
        DarcId darcId = new DarcId(proof.getValues().get(0));
        InstanceId darcInstanceId = new InstanceId(darcId, SubId.zero());
        proof = OmniledgerRPC.getProof(roster, skipchainId, darcInstanceId);
        OmniledgerRPC.checkProof(proof, "darc");
        try {
            this.genesisDarc = new Darc(proof.getValues().get(0));
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
        InstanceId configInstanceId = new InstanceId(darcId, SubId.one());
        proof = OmniledgerRPC.getProof(roster, skipchainId, configInstanceId);
        OmniledgerRPC.checkProof(proof, "config");
        this.config = new Config(proof.getValues().get(0));
        this.skipchain = new SkipchainRPC(roster, skipchainId);
        this.roster = roster;
        this.genesis = this.skipchain.getSkipblock(skipchainId);
        this.latest = this.skipchain.getLatestSkipblock();
    }

    public OmniledgerRPC(byte[] buf) {
        throw new RuntimeException("Not implemented yet");
    }

    public void sendTransaction(ClientTransaction t) throws CothorityException {
        this.sendTransactionAndWait(t, 0);
    }

    public void sendTransactionAndWait(ClientTransaction t, int wait) throws CothorityException {
        OmniLedgerProto.AddTxRequest.Builder request = OmniLedgerProto.AddTxRequest.newBuilder();
        request.setVersion(1);
        request.setSkipchainid(ByteString.copyFrom((byte[])this.skipchain.getID().getId()));
        request.setTransaction(t.toProto());
        request.setInclusionwait(wait);
        ByteString msg = this.roster.sendMessage("OmniLedger/AddTxRequest", request.build());
        try {
            OmniLedgerProto.AddTxResponse reply = OmniLedgerProto.AddTxResponse.parseFrom(msg);
            this.logger.info("Successfully stored request - waiting for inclusion");
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public Proof getProof(InstanceId id) throws CothorityException {
        OmniLedgerProto.GetProof.Builder request = OmniLedgerProto.GetProof.newBuilder();
        request.setVersion(1);
        request.setId(this.skipchain.getID().toProto());
        request.setKey(id.toByteString());
        ByteString msg = this.roster.sendMessage("OmniLedger/GetProof", request.build());
        try {
            OmniLedgerProto.GetProofResponse reply = OmniLedgerProto.GetProofResponse.parseFrom(msg);
            this.logger.info("Successfully received proof");
            return new Proof(reply.getProof());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public void update() throws CothorityException {
        SkipBlock sb = this.skipchain.getLatestSkipblock();
        if (sb != null) {
            this.latest = sb;
        }
    }

    public boolean checkLiveness() throws CothorityException {
        for (ServerIdentity si : this.roster.getNodes()) {
            try {
                this.logger.info("Checking status of {}", (Object)si.getAddress());
                si.GetStatus();
            }
            catch (CothorityCommunicationException e) {
                this.logger.warn("Failing node {}: {}", (Object)si.getAddress(), (Object)e.toString());
                return false;
            }
        }
        return true;
    }

    public byte[] toBytes() {
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public Darc getGenesisDarc() {
        return this.genesisDarc;
    }

    public SkipBlock getLatest() {
        return this.latest;
    }

    public SkipBlock getGenesis() {
        return this.genesis;
    }

    public Roster getRoster() {
        return this.roster;
    }

    private static void checkProof(Proof proof, String expectedContract) throws CothorityNotFoundException {
        if (!proof.matches()) {
            throw new CothorityNotFoundException("couldn't find darc");
        }
        if (proof.getValues().size() != 2) {
            throw new CothorityNotFoundException("incorrect number of values in proof");
        }
        String contract = new String(proof.getValues().get(1));
        if (!contract.equals(expectedContract)) {
            throw new CothorityNotFoundException("contract name is not " + expectedContract + ", got " + contract);
        }
    }

    private static Proof getProof(Roster roster, SkipblockId skipchainId, InstanceId key) throws CothorityCommunicationException {
        OmniLedgerProto.GetProof.Builder configBuilder = OmniLedgerProto.GetProof.newBuilder();
        configBuilder.setVersion(1);
        configBuilder.setId(skipchainId.toProto());
        configBuilder.setKey(key.toByteString());
        ByteString msg = roster.sendMessage("OmniLedger/GetProof", configBuilder.build());
        try {
            OmniLedgerProto.GetProofResponse reply = OmniLedgerProto.GetProofResponse.parseFrom(msg);
            return new Proof(reply.getProof());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }
}

